/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import org.corebounce.common.utils.Out;

public class ConcurrentDelayBuffer {
    private final int delay;
    private final int capacity;
    private final int blockSize;
    private final float[] buffer;

    public ConcurrentDelayBuffer(int delay, int capacity, int blockSize) {
        this.delay = delay;
        this.capacity = capacity;
        this.blockSize = blockSize;
        this.buffer = new float[capacity];
    }

    public ConcurrentDelayBuffer(int delay, int blockSize, IMtContext mtContext) {
        this(delay, delay + blockSize * mtContext.getSerialRunningMaxSkew(), blockSize);
    }

    public void push(float[] input, long clock) {
        if (input.length != this.blockSize) {
            throw new IllegalArgumentException();
        }
        int index = (int)((clock * (long)this.blockSize + (long)this.delay) % (long)this.capacity);
        int i = 0;
        while (i < input.length) {
            this.buffer[index] = input[i];
            index = (index + 1) % this.capacity;
            ++i;
        }
    }

    public void pop(@Out float[] output, long clock) {
        if (output.length != this.blockSize) {
            throw new IllegalArgumentException();
        }
        int index = (int)(clock * (long)this.blockSize % (long)this.capacity);
        int i = 0;
        while (i < output.length) {
            output[i] = this.buffer[index];
            index = (index + 1) % this.capacity;
            ++i;
        }
    }

    public void push(float value, long clock) {
        if (this.blockSize != 1) {
            throw new IllegalArgumentException();
        }
        int index = (int)((clock + (long)this.delay) % (long)this.capacity);
        this.buffer[index] = value;
    }

    public float pop(long clock) {
        int index = (int)(clock % (long)this.capacity);
        return this.buffer[index];
    }

    public int getDelay() {
        return this.delay;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getBlockSize() {
        return this.blockSize;
    }
}

