/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.utils.Out;

public class ConcurrentDivider
implements IHasSerialSections {
    private static final String IN_SECTION_NAME = String.valueOf(ConcurrentDivider.class.getName()) + ".input";
    private static final String OUT_SECTION_NAME = String.valueOf(ConcurrentDivider.class.getName()) + ".output";
    private final int subSizeIn;
    private final int subSizeOut;
    private final int nbBlocks;
    private final int nbLayersIn;
    private float[][] inBuffer;
    private float[] outBuffer;
    private ISerialSection inSection = new DummySerialSection();
    private ISerialSection outSection = new DummySerialSection();

    public ConcurrentDivider(int subSizeIn, int subSizeOut, int nbBlocks, int nbLayersIn) {
        this.subSizeIn = subSizeIn;
        this.subSizeOut = subSizeOut;
        this.nbBlocks = nbBlocks;
        this.nbLayersIn = nbLayersIn;
    }

    public boolean push(float[][] input, @Out float[][] fullBlock) {
        if (input.length != this.nbLayersIn) {
            throw new IllegalArgumentException();
        }
        if (input[0].length != this.subSizeIn) {
            throw new IllegalArgumentException();
        }
        int bufferLength = this.inBuffer[0].length;
        long clock = this.inSection.getClock();
        int index = (int)(clock * (long)this.subSizeIn % (long)bufferLength);
        int k = 0;
        while (k < this.nbLayersIn) {
            System.arraycopy(input[k], 0, this.inBuffer[k], index, this.subSizeIn);
            ++k;
        }
        this.inSection.sync();
        if ((clock + 1L) % (long)this.nbBlocks == 0L) {
            if (fullBlock.length != this.nbLayersIn) {
                throw new IllegalArgumentException();
            }
            if (fullBlock[0].length != this.subSizeIn * this.nbBlocks) {
                throw new IllegalArgumentException();
            }
            int startIndex = (index - this.subSizeIn * (this.nbBlocks - 1) + bufferLength) % bufferLength;
            int k2 = 0;
            while (k2 < this.nbLayersIn) {
                int i = 0;
                while (i < this.subSizeIn * this.nbBlocks) {
                    fullBlock[k2][i] = this.inBuffer[k2][(startIndex + i) % bufferLength];
                    ++i;
                }
                ++k2;
            }
            return true;
        }
        return false;
    }

    public void pop(float[] fullBlock, @Out float[] output) {
        if (output.length != this.subSizeOut) {
            throw new IllegalArgumentException();
        }
        long clock = this.outSection.getClock() - (long)this.nbBlocks + 1L;
        int index = (int)((clock * (long)this.subSizeOut + (long)this.outBuffer.length) % (long)this.outBuffer.length);
        if (clock % (long)this.nbBlocks == 0L) {
            if (fullBlock.length != this.subSizeOut * this.nbBlocks) {
                throw new IllegalArgumentException();
            }
            int startIndex = index;
            int i = 0;
            while (i < this.subSizeOut * this.nbBlocks) {
                this.outBuffer[(startIndex + i) % this.outBuffer.length] = fullBlock[i];
                ++i;
            }
        }
        this.outSection.sync();
        System.arraycopy(this.outBuffer, index, output, 0, this.subSizeOut);
    }

    public int getLatency() {
        return (this.nbBlocks - 1) * this.subSizeOut;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        int maxSkew = factory.getMtContext().getSerialRunningMaxSkew();
        this.inBuffer = new float[this.nbLayersIn][this.subSizeIn * (this.nbBlocks + maxSkew)];
        this.outBuffer = new float[this.subSizeOut * (this.nbBlocks + maxSkew)];
        this.inSection = factory.createSerialSection(IN_SECTION_NAME, (Object)this.inBuffer);
        this.outSection = factory.createSerialSection(OUT_SECTION_NAME, (Object)this.outBuffer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.inSection = pool.getSerialSection(IN_SECTION_NAME);
        this.outSection = pool.getSerialSection(OUT_SECTION_NAME);
        this.inBuffer = (float[][])this.inSection.getUserData();
        this.outBuffer = (float[])this.outSection.getUserData();
    }
}

