/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Out;

public class PeakPicker {
    private float[] powerMags;
    private int[] bounds;
    private int[] peakLocations;
    private int nbPeaks;

    public PeakPicker(int nbBins) {
        int maxNbPeaks = nbBins / 3 + 1;
        this.bounds = new int[maxNbPeaks + 1];
        this.peakLocations = new int[maxNbPeaks];
    }

    public static void fillPowerMags(Cmplx[] spectrum, @Out float[] powerMags) {
        if (spectrum.length != powerMags.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < spectrum.length) {
            powerMags[i] = spectrum[i].powerMag();
            ++i;
        }
    }

    public void pick(float[] powerMags) {
        this.nbPeaks = 0;
        this.powerMags = powerMags;
        int i = 0;
        while (i < powerMags.length) {
            if (this.isPeak(i)) {
                this.peakLocations[this.nbPeaks] = i;
                ++this.nbPeaks;
            }
            ++i;
        }
        this.bounds[0] = 0;
        i = 0;
        while (i < this.nbPeaks - 1) {
            int peak1 = this.peakLocations[i];
            int peak2 = this.peakLocations[i + 1];
            int middle = (peak1 + peak2) / 2;
            while (middle > peak1 + 1 && this.valueAt(middle - 1) < this.valueAt(middle)) {
                --middle;
            }
            while (middle < peak2 - 1 && this.valueAt(middle + 1) < this.valueAt(middle)) {
                ++middle;
            }
            this.bounds[i + 1] = middle;
            ++i;
        }
        this.bounds[this.nbPeaks] = powerMags.length;
    }

    private float valueAt(int i) {
        if (i < 0 || i >= this.powerMags.length) {
            return 0.0f;
        }
        return this.powerMags[i];
    }

    private boolean isPeak(int i) {
        float pm = this.valueAt(i);
        return pm >= this.valueAt(i - 1) && pm >= this.valueAt(i - 2) && pm > this.valueAt(i + 1) && pm > this.valueAt(i + 2);
    }

    public int getNbPeaks() {
        return this.nbPeaks;
    }

    public int getPeakLocation(int peakIndex) {
        return this.peakLocations[peakIndex];
    }

    public int getPeakLowerBound(int peakIndex) {
        return this.bounds[peakIndex];
    }

    public int getPeakUpperBound(int peakIndex) {
        return this.bounds[peakIndex + 1];
    }
}

