/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class AiffAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    public AiffAudioFileReader() {
        super(1000);
    }

    private void skipChunk(DataInputStream dataInputStream, int chunkLength, int chunkRead) throws IOException {
        if ((chunkLength -= chunkRead) > 0) {
            dataInputStream.skip(chunkLength + chunkLength % 2);
        }
    }

    private AudioFormat readCommChunk(DataInputStream dataInputStream, int chunkLength) throws IOException, UnsupportedAudioFileException {
        int nFrameSize;
        short nNumChannels = dataInputStream.readShort();
        if (nNumChannels <= 0) {
            throw new UnsupportedAudioFileException("not an AIFF file: number of channels must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("Found " + nNumChannels + " channels.");
        }
        dataInputStream.readInt();
        int nSampleSize = dataInputStream.readShort();
        float fSampleRate = (float)AiffAudioFileReader.readIeeeExtended(dataInputStream);
        if ((double)fSampleRate <= 0.0) {
            throw new UnsupportedAudioFileException("not an AIFF file: sample rate must be positive");
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("Found framerate " + fSampleRate);
        }
        AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
        int nRead = 18;
        if (chunkLength > nRead) {
            int nEncoding = dataInputStream.readInt();
            nRead += 4;
            if (nEncoding != 1313820229) {
                if (nEncoding == 1718367026 || nEncoding == 1179398962) {
                    encoding = Encodings.PCM_IEEE_FLOAT;
                    nSampleSize = 32;
                } else if (nEncoding == 1718367796) {
                    encoding = Encodings.PCM_IEEE_FLOAT;
                    nSampleSize = 64;
                } else if (nEncoding == 1970037111) {
                    encoding = AudioFormat.Encoding.ULAW;
                    nSampleSize = 8;
                } else if (nEncoding == 1768775988) {
                    encoding = new AudioFormat.Encoding("IMA_ADPCM");
                    nSampleSize = 4;
                } else {
                    throw new UnsupportedAudioFileException("Encoding 0x" + Integer.toHexString(nEncoding) + " of AIFF file not supported");
                }
            }
        }
        int n = nFrameSize = nSampleSize == 4 ? -1 : AiffAudioFileReader.calculateFrameSize(nSampleSize, nNumChannels);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("calculated frame size: " + nFrameSize);
        }
        this.skipChunk(dataInputStream, chunkLength, nRead);
        AudioFormat format = new AudioFormat(encoding, fSampleRate, nSampleSize, nNumChannels, nFrameSize, fSampleRate, nSampleSize > 8);
        return format;
    }

    private void readVerChunk(DataInputStream dataInputStream, int chunkLength) throws IOException, UnsupportedAudioFileException {
        if (chunkLength < 4) {
            throw new UnsupportedAudioFileException("Corrput AIFF file: FVER chunk too small.");
        }
        int nVer = dataInputStream.readInt();
        if (nVer != -1568648896) {
            throw new UnsupportedAudioFileException("Unsupported AIFF file: version not known.");
        }
        this.skipChunk(dataInputStream, chunkLength, 4);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileSizeInBytes) throws UnsupportedAudioFileException, IOException {
        boolean bIsAifc;
        DataInputStream dataInputStream;
        int nMagic;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        if ((nMagic = (dataInputStream = new DataInputStream(inputStream)).readInt()) != 1179603533) {
            throw new UnsupportedAudioFileException("not an AIFF file: header magic is not FORM");
        }
        int nTotalLength = dataInputStream.readInt();
        nMagic = dataInputStream.readInt();
        if (nMagic == 1095321158) {
            bIsAifc = false;
        } else if (nMagic == 1095321155) {
            bIsAifc = true;
        } else {
            throw new UnsupportedAudioFileException("unsupported IFF file: header magic neither AIFF nor AIFC");
        }
        boolean bFVerFound = !bIsAifc;
        boolean bCommFound = false;
        boolean bSSndFound = false;
        AudioFormat format = null;
        int nDataChunkLength = 0;
        block5: while (!(bFVerFound && bCommFound && bSSndFound)) {
            nMagic = dataInputStream.readInt();
            int nChunkLength = dataInputStream.readInt();
            switch (nMagic) {
                case 1129270605: {
                    format = this.readCommChunk(dataInputStream, nChunkLength);
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out("Read COMM chunk with length " + nChunkLength);
                    }
                    bCommFound = true;
                    break;
                }
                case 1180058962: {
                    if (!bFVerFound) {
                        this.readVerChunk(dataInputStream, nChunkLength);
                        if (TDebug.TraceAudioFileReader) {
                            TDebug.out("Read FVER chunk with length " + nChunkLength);
                        }
                        bFVerFound = true;
                        break;
                    }
                    this.skipChunk(dataInputStream, nChunkLength, 0);
                    break;
                }
                case 1397968452: {
                    if (!bCommFound || !bFVerFound) {
                        throw new UnsupportedAudioFileException("cannot handle AIFF file: SSND not last chunk");
                    }
                    bSSndFound = true;
                    nDataChunkLength = nChunkLength - 8;
                    dataInputStream.skip(8L);
                    if (!TDebug.TraceAudioFileReader) continue block5;
                    TDebug.out("Found SSND chunk with length " + nChunkLength);
                    break;
                }
                default: {
                    if (TDebug.TraceAudioFileReader) {
                        TDebug.out("Skipping unknown chunk: " + Integer.toHexString(nMagic));
                    }
                    this.skipChunk(dataInputStream, nChunkLength, 0);
                }
            }
        }
        TAudioFileFormat audioFileFormat = new TAudioFileFormat(bIsAifc ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF, format, nDataChunkLength / format.getFrameSize(), nTotalLength + 8);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AiffAudioFileReader.getAudioFileFormat(InputStream, long): end");
        }
        return audioFileFormat;
    }
}

