/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.apps;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.PCMProcessor;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.util.ByteData;

public class Player
implements PCMProcessor {
    private AudioFormat fmt;
    private DataLine.Info info;
    private SourceDataLine line;
    private Vector listeners = new Vector();

    public void addListener(LineListener listener) {
        this.listeners.add(listener);
    }

    public void decode(String inFileName) throws IOException, LineUnavailableException {
        FileInputStream is = new FileInputStream(inFileName);
        FLACDecoder decoder = new FLACDecoder(is);
        decoder.addPCMProcessor(this);
        try {
            decoder.decode();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.line.drain();
        this.line.close();
        this.listeners.clear();
    }

    public void processStreamInfo(StreamInfo streamInfo) {
        try {
            this.fmt = streamInfo.getAudioFormat();
            this.info = new DataLine.Info(SourceDataLine.class, this.fmt, -1);
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            int size = this.listeners.size();
            int index = 0;
            while (index < size) {
                this.line.addLineListener((LineListener)this.listeners.get(index));
                ++index;
            }
            this.line.open(this.fmt, -1);
            this.line.start();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void processPCM(ByteData pcm) {
        this.line.write(pcm.getData(), 0, pcm.getLen());
    }

    public void removeListener(LineListener listener) {
        this.listeners.removeElement(listener);
    }

    public static void main(String[] args) {
        try {
            Player decoder = new Player();
            int i = 0;
            while (i < args.length) {
                decoder.decode(args[i]);
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

