/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics;

import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.TachyonSonicsFrame;
import ch.tachyon.sonics.gui.progress.ProgressManager;
import ch.tachyon.tunnel.utils.ThreadUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class Controller {
    private Session session;
    private TachyonSonicsFrame frame;
    private ProgressManager progressManager;

    public Controller(Session session, TachyonSonicsFrame frame) {
        this.session = session;
        this.frame = frame;
        this.progressManager = new ProgressManager(frame);
    }

    public Session getSession() {
        return this.session;
    }

    public TachyonSonicsFrame getFrame() {
        return this.frame;
    }

    public ProgressManager getProgressManager() {
        return this.progressManager;
    }

    public TachyonSonicsFrame rebuildFrame() {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<AudioFile> files = new ArrayList<AudioFile>(this.session.getFiles());
        AudioFile currentFile = this.session.getCurrentFile();
        for (AudioFile file : files) {
            this.session.removeFile(file);
            file.clearListeners();
            file.clearViews();
        }
        this.session.clearListeners();
        int state = this.frame.getExtendedState();
        this.frame.setExtendedState(0);
        Point location = this.frame.getLocation();
        Dimension size = this.frame.getSize();
        this.frame.setVisible(false);
        this.frame.dispose();
        this.frame = new TachyonSonicsFrame();
        this.frame.setSize(size);
        this.frame.setLocation(location);
        this.progressManager = new ProgressManager(this.frame);
        this.frame.init(this);
        this.frame.setExtendedState(state);
        this.frame.setVisible(true);
        for (AudioFile file : files) {
            this.session.addFile(file);
        }
        if (currentFile != null) {
            this.session.setCurrentFile(currentFile);
        }
        return this.frame;
    }

    public void quit() {
        Transport.getInstance().dispose();
        this.session.dispose();
        if (this.frame == null) {
            return;
        }
        this.frame.quit();
        Thread hardKiller = new Thread("Quit"){

            public void run() {
                ThreadUtils.sleep((int)10000);
                System.exit(0);
            }
        };
        hardKiller.setDaemon(true);
        hardKiller.start();
    }
}

