/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics;

import ch.tachyon.sonics.ActionPool;
import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.TachyonSonics;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.Session;
import java.io.File;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.log.LogFormatter;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.common.utils.IDisposable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TachyonEngine
implements IDisposable {
    private static final String PLUGINS_DIRECTORY = "plugins";
    private final Controller controller;

    public TachyonEngine() {
        LogFormatter.setup();
        AppUtils.setAppName("Tachyon Sonics");
        ClassLoaderUtils.addAllJarsToClassPath(new File(AppUtils.getApplicationDirectory(TachyonSonics.class), PLUGINS_DIRECTORY));
        AwtTools.init();
        Session session = new Session();
        this.controller = new Controller(session, null);
    }

    public Controller getController() {
        return this.controller;
    }

    public Session getSession() {
        return this.controller.getSession();
    }

    public <A extends ActionBase> void execute(Class<A> actionType) throws InstantiationException, IllegalAccessException, InterruptedException {
        ActionBase action = (ActionBase)actionType.newInstance();
        action.setController(this.controller);
        action.actionPerformed(null);
        ActionPool.waitForAllActions(null, false);
    }

    public void execute(ActionBase action) {
        action.setController(this.controller);
        action.actionPerformed(null);
        ActionPool.waitForAllActions(null, false);
    }

    @Override
    public void dispose() {
        this.controller.getSession().dispose();
    }
}

