/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.file.OpenAction;
import ch.tachyon.sonics.core.FileTypeSpiUtils;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.gui.SwingPreCompiler;
import ch.tachyon.sonics.gui.TachyonSonicsFrame;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.lang.management.ThreadInfo;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.Console;
import org.corebounce.common.log.LogFormatter;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.DeadlockDetector;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;
import org.corebounce.common.utils.StringUtils;

public class TachyonSonics {
    private static void init() {
        boolean console;
        boolean bl = console = System.getProperty("console") != null;
        if (!console) {
            LogFormatter.setup();
        }
        TachyonSonics.setupSecurity();
        TachyonSonics.setupCaching();
        TachyonSonics.setupDeadlockDetection();
        AppUtils.setAppName("Tachyon Sonics");
        if (Platform.isMacOsX()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Tachyon Sonics");
        }
        AwtTools.init();
        if (StringUtils.isBlank(System.getProperty("swing.defaultlaf"))) {
            AwtTools.switchToNativeLookAndFeel();
        }
        if (console) {
            Console.redirectStdOutAndStdErr(false);
            LogFormatter.setup();
        }
        FileTypeSpiUtils.pushSpiClassPath();
    }

    private static void start(String[] args) {
        Session session = new Session();
        TachyonSonicsFrame frame = new TachyonSonicsFrame();
        Controller controller = new Controller(session, frame);
        frame.init(controller);
        AwtTools.centerWindowOnScreen(frame);
        frame.setExtendedState(6);
        frame.setVisible(true);
        if (Platform.getPlatform().equals((Object)PlatformType.LINUX) && Platform.isGcj() && Platform.isBelowJava16() && "Tachyon-Sonics.jar".equals(System.getProperty("gnu.gcj.progname"))) {
            TachyonSonics.warnAboutGcj(frame);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingPreCompiler.start();
            }
        });
        if (args.length > 0) {
            ArrayList<File> files = new ArrayList<File>();
            int i = 0;
            while (i < args.length) {
                if (!args[i].startsWith("-")) {
                    File file = new File(args[i]);
                    files.add(file);
                }
                ++i;
            }
            if (!files.isEmpty()) {
                final OpenAction openAction = MenuBar.getInstance().getFileMenu().getOpenAction();
                openAction.setFilesToOpen(files.toArray(new File[files.size()]));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        openAction.actionPerformed(null);
                        openAction.setFilesToOpen(null);
                    }
                });
            }
        }
    }

    private static void warnAboutGcj(JFrame parent) {
        JOptionPane.showMessageDialog(parent, "This application is running on GIJ/GCJ. This JVM is slow, buggy and lacks audio support.\nIt is strongly recommanded that you install and use the OpenJDK's JRE version 6\nor greater instead. It offers audio recording and playback support as well as optimal\nperformances. The package to install is 'openjdk-X-jre' (where X is the latest version\nnumber) on Debian, and 'java-X-openjdk.*' on Fedora.", "Warning - Unsupported JVM", 2);
    }

    private static void setupSecurity() {
        if (System.getSecurityManager() != null) {
            Debug.warn((String)"A security manager is already installed. The Application may not be fully functional", (Object[])new Object[0]);
            return;
        }
        URL policyUrl = TachyonSonics.class.getResource("/application-dev.policy");
        if (policyUrl == null) {
            System.setProperty("ch.tachyon.sonics.app.dir", AppUtils.getApplicationDirectory(TachyonSonics.class).getAbsolutePath().replace(File.separator, "/"));
            policyUrl = TachyonSonics.class.getResource("/application.policy");
        } else {
            System.setProperty("ch.tachyon.sonics.app.dir", new File("").getAbsolutePath());
        }
        System.setProperty("java.security.policy", policyUrl.toString());
        System.setSecurityManager(new SecurityManager());
    }

    private static void setupCaching() {
        long maxMem = Runtime.getRuntime().maxMemory();
        if (maxMem < 0x5A00000L && !Platform.isBelowJava16()) {
            System.setProperty("NoCache", "true");
        }
        if (maxMem < 0xC800000L) {
            System.setProperty("NoHardCache", "true");
        }
    }

    private static void setupDeadlockDetection() {
        DeadlockDetector dld = new DeadlockDetector(new DeadlockDetector.DefaultCallback(){

            public void threadsDeadlocked(ThreadInfo[] threads) {
                super.threadsDeadlocked(threads);
                System.exit(2);
            }
        });
        dld.start();
    }

    public static void main(final String[] args) {
        TachyonSonics.init();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TachyonSonics.start(args);
            }
        });
    }
}

