/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action;

import ch.tachyon.sonics.ActionPool;
import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.ActionThreadFactory;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.core.IToolboxItem;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.sonics.gui.message.MessageType;
import ch.tachyon.sonics.gui.progress.ProgressManager;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Utils;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.HtmlEncoder;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActionBase
extends AbstractAction
implements Cloneable,
IToolboxItem {
    private static final boolean PHILIPPE_LANG_MODE = false;
    private static final String SWING_LARGE_ICON_KEY = "SwingLargeIconKey";
    private static final String SWING_SELECTED_KEY = "SwingSelectedKey";
    private static final String TEXT_FORMAT = "<html><body><b>{0}</b></body></html>";
    private static final String TEXT_DESCRIPTION_FORMAT = "<html><body><b>{0}</b><p>{1}</body></html>";
    private static final String TEXT_SHORTCUT_FORMAT = "<html><body><b>{0}</b><p><small><i>Shortcut key: </i>{2}</small></font></body></html>";
    private static final String SHORTCUT_FORMAT = "<html><body><small><i>Shortcut key: </i>{2}</small></body></html>";
    private static final String DESCRIPTION_FORMAT = "<html><body>{1}</body></html>";
    private static final String DESCRIPTION_SHORTCUT_FORMAT = "<html><body>{1}<p><small><i>Shortcut key: </i>{2}</small></body></html>";
    private static final String TEXT_SHORTCUT_DESCRIPTION_FORMAT = "<html><body><b>{0}</b><p>{1}<p><small><i>Shortcut key: </i>{2}</small></body></html>";
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new ActionThreadFactory());
    protected Controller controller;
    protected Session session;
    private ActionBase parent;
    private List<KeyStroke> keyboardShortcuts;
    private boolean manualUpdate = false;
    private AbstractButton toolbarButton = null;
    private JMenuItem menuItem = null;
    private boolean lastSelected = false;
    private transient int modifiers;

    public void setController(Controller controller) {
        this.controller = controller;
        this.session = controller.getSession();
        this.lookupIcon();
        this.init();
    }

    public void setSession(Session session) {
        this.session = session;
        this.lookupIcon();
        this.init();
    }

    protected int getIconSize() {
        return 16;
    }

    private void lookupIcon() {
        String path = this.getClass().getName();
        int lastDot = path.lastIndexOf(46);
        String name = String.valueOf(path.substring(lastDot + 1)) + ".png";
        int size = this.getIconSize();
        ImageIcon icon = IconLoader.getImageIcon(this.getClass(), name, size, size);
        if (icon != null) {
            this.putValue(SWING_LARGE_ICON_KEY, icon);
        }
        if (this.getIconSize() != 16) {
            icon = IconLoader.getImageIcon(this.getClass(), name, 16, 16);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
        } else {
            this.putValue("SmallIcon", icon);
        }
    }

    protected void init() {
    }

    @Override
    public ActionBase getParent() {
        return this.parent;
    }

    protected void setParent(ActionBase parent) {
        this.parent = parent;
    }

    protected static int getMenuModifier() {
        return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }

    protected void setDetails(String text, int menuShortCut, int mnemonic) {
        this.setText(text);
        this.setAccelerator(menuShortCut);
        this.setMnemonic(mnemonic);
    }

    protected void setDetails(String text, int mnemonic) {
        this.setText(text);
        this.setMnemonic(mnemonic);
    }

    protected void setText(String text) {
        this.putValue("Name", text);
    }

    public String getText() {
        return (String)this.getValue("Name");
    }

    @Override
    public String getName() {
        return this.getText();
    }

    protected String getProgressTitle() {
        return this.getText();
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    protected void setTooltip(String text) {
        this.putValue("ShortDescription", text);
    }

    public String getTooltip() {
        return (String)this.getValue("ShortDescription");
    }

    protected void setAccelerator(int ch) {
        int modifiers = 0;
        if (Character.isUpperCase(ch)) {
            modifiers = 64;
        } else {
            ch = Character.toUpperCase(ch);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(ch, ActionBase.getMenuModifier() | modifiers);
        this.setAccelerator(keyStroke);
    }

    protected void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    protected void setMnemonic(int ch) {
        if (!Platform.isMacOsX()) {
            this.putValue("MnemonicKey", ch);
        }
    }

    protected void addKeyboardShortcut(int keyCode) {
        this.addKeyboardShortcut(KeyStroke.getKeyStroke(keyCode, 0));
    }

    protected void addKeyboardShortcut(KeyStroke keyStroke) {
        if (this.keyboardShortcuts == null) {
            this.keyboardShortcuts = new ArrayList<KeyStroke>(2);
        }
        this.keyboardShortcuts.add(keyStroke);
    }

    public synchronized void setSelected(boolean value) {
        if (value != this.lastSelected) {
            this.putValue(SWING_SELECTED_KEY, value);
        }
        this.lastSelected = value;
    }

    protected boolean isSelected() {
        return this.lastSelected;
    }

    protected final int getModifiers() {
        return this.modifiers;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.NORMAL;
    }

    public final boolean isToggle() {
        return this.getDisplayType() == ActionDisplayType.CHECKBOX || this.getDisplayType() == ActionDisplayType.TOGGLE;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        ActionBase instance = this.clone();
        instance.modifiers = e == null ? 0 : e.getModifiers();
        instance.perform(e);
    }

    private void launch(Runnable runnable) {
        threadPool.execute(runnable);
    }

    private void perform(final ActionEvent e) {
        if (!ActionPool.addActiveAction(this)) {
            return;
        }
        this.logAction(this.getAudioFile());
        final Runnable postGui = new Runnable(){

            public void run() {
                try {
                    try {
                        ActionBase.this.guiPostProcess(e);
                    }
                    catch (Throwable ex) {
                        Debug.error((Throwable)ex);
                        ActionPool.removeActiveAction(ActionBase.this);
                    }
                }
                finally {
                    ActionPool.removeActiveAction(ActionBase.this);
                }
            }
        };
        final Runnable process = new Runnable(){

            public void run() {
                IProgressMonitor progressMonitor = null;
                try {
                    try {
                        if (ActionBase.this.controller != null) {
                            ProgressManager pm = ActionBase.this.controller.getProgressManager();
                            progressMonitor = pm.createProgressMonitor(ActionBase.this.getProgressTitle());
                            ActionPool.setProgressMonitor(ActionBase.this, progressMonitor);
                            progressMonitor.setText(ActionBase.this.getActionName(), new Object[0]);
                        }
                        AudioFile file = ActionBase.this.getAudioFile();
                        boolean res = false;
                        String actionName = ActionBase.this.getActionName();
                        if (file != null) {
                            file.lockWrite(actionName, true, progressMonitor);
                        }
                        try {
                            if (file != null) {
                                ActionBase.this.preProcessSelection(file);
                            }
                            res = ActionBase.this.process(e, progressMonitor);
                            if (file != null) {
                                ActionBase.this.postProcessSelection(file);
                            }
                        }
                        finally {
                            if (file != null) {
                                file.unlockWrite(actionName);
                            }
                        }
                        if (res) {
                            SwingUtilities.invokeLater(postGui);
                        } else {
                            ActionPool.removeActiveAction(ActionBase.this);
                        }
                    }
                    catch (OperationAbortedException ex) {
                        ActionPool.removeActiveAction(ActionBase.this);
                        if (progressMonitor != null) {
                            progressMonitor.dispose();
                        }
                    }
                    catch (Throwable ex) {
                        Debug.error((Throwable)ex);
                        ActionPool.removeActiveAction(ActionBase.this);
                        if (progressMonitor != null) {
                            progressMonitor.dispose();
                        }
                    }
                }
                finally {
                    if (progressMonitor != null) {
                        progressMonitor.dispose();
                    }
                }
            }
        };
        final Runnable preGui = new Runnable(){

            public void run() {
                try {
                    boolean res = ActionBase.this.guiPreProcess(e);
                    if (res) {
                        ActionBase.this.launch(process);
                    } else {
                        ActionPool.removeActiveAction(ActionBase.this);
                    }
                }
                catch (Throwable ex) {
                    Debug.error((Throwable)ex);
                    ActionPool.removeActiveAction(ActionBase.this);
                }
            }
        };
        Runnable preProcess = new Runnable(){

            public void run() {
                try {
                    boolean res = ActionBase.this.preProcess(e);
                    if (res) {
                        SwingUtilities.invokeLater(preGui);
                    } else {
                        ActionPool.removeActiveAction(ActionBase.this);
                    }
                }
                catch (Throwable ex) {
                    Debug.error((Throwable)ex);
                    ActionPool.removeActiveAction(ActionBase.this);
                }
            }
        };
        this.launch(preProcess);
    }

    protected boolean preProcess(ActionEvent e) throws Exception {
        return true;
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        return true;
    }

    protected void preProcessSelection(AudioFile audioFile) {
        audioFile.addCurrentSelectionToHistory();
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return true;
    }

    protected void postProcessSelection(AudioFile audioFile) {
    }

    protected void guiPostProcess(ActionEvent e) throws Exception {
    }

    protected AudioFile getAudioFile() {
        if (this.session == null) {
            return null;
        }
        return this.session.getCurrentFile();
    }

    protected String getActionName() {
        String result = this.getClass().getSimpleName();
        if (result.endsWith("Action")) {
            result = result.substring(0, result.length() - "Action".length());
        }
        return result;
    }

    private void logAction(AudioFile file) {
        String actionType = this.getActionName();
        if (file == null) {
            Debug.info((String)"{0} on no file", (Object[])new Object[]{actionType});
        } else {
            SelectionInfo sInfo = file.getSelection();
            Debug.info((String)"{0} on file {1}, {2}", (Object[])new Object[]{actionType, file, sInfo});
        }
    }

    protected void logActionSuccessful(AudioFile file, String actionName) {
        String text = String.valueOf(actionName) + " applied";
        String details = file == null || file.getFile() == null ? null : "The effect was applied on file \"" + file.getFile().getName() + "\"";
        Message message = new Message(MessageType.SUCCESSFUL, text, details);
        message.publish();
    }

    protected void logActionWarning(AudioFile file, String actionName, String operation) {
        String text = String.valueOf(actionName) + " " + operation;
        String details = file == null || file.getFile() == null ? "" : "The effect was started on file \"" + file.getFile().getName() + "\".\n";
        details = operation.equals("cancelled") ? String.valueOf(details) + "The file has not been modified." : String.valueOf(details) + "Only a part of the selection has been modified.";
        Message message = new Message(MessageType.WARNING, text, details);
        message.publish();
    }

    @Override
    public ActionBase clone() {
        try {
            return (ActionBase)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private boolean isWorthDisplayingShortcut() {
        KeyStroke accel = (KeyStroke)super.getValue("AcceleratorKey");
        if (accel.getModifiers() != 0) {
            return false;
        }
        char ch = accel.getKeyChar();
        return ch >= ' ' && ch < '\u007f';
    }

    protected String getFullTooltipText(boolean menu, boolean iconOnly) {
        String text = null;
        String description = null;
        String shortcut = null;
        if (iconOnly) {
            text = this.getText();
        }
        description = this.getTooltip();
        if (menu && Platform.isMacOsX()) {
            return description;
        }
        KeyStroke accel = (KeyStroke)super.getValue("AcceleratorKey");
        if (accel != null) {
            if (!menu || this.isWorthDisplayingShortcut()) {
                shortcut = String.valueOf(KeyEvent.getKeyModifiersText(accel.getModifiers())) + " " + KeyEvent.getKeyText(accel.getKeyCode());
            }
        } else if (this.keyboardShortcuts != null) {
            for (KeyStroke keyStroke : this.keyboardShortcuts) {
                String shortcut0 = KeyEvent.getKeyText(keyStroke.getKeyCode());
                if (keyStroke.getModifiers() != 0) {
                    shortcut0 = String.valueOf(KeyEvent.getKeyModifiersText(keyStroke.getModifiers())) + " " + shortcut0;
                }
                shortcut = shortcut == null ? shortcut0 : String.valueOf(shortcut) + ", " + shortcut0;
            }
        }
        int indexer = (text != null ? 4 : 0) + (description != null ? 2 : 0) + (shortcut != null ? 1 : 0);
        String[] stringArray = new String[8];
        stringArray[1] = SHORTCUT_FORMAT;
        stringArray[2] = DESCRIPTION_FORMAT;
        stringArray[3] = DESCRIPTION_SHORTCUT_FORMAT;
        stringArray[4] = TEXT_FORMAT;
        stringArray[5] = TEXT_SHORTCUT_FORMAT;
        stringArray[6] = TEXT_DESCRIPTION_FORMAT;
        stringArray[7] = TEXT_SHORTCUT_DESCRIPTION_FORMAT;
        String[] patterns = stringArray;
        String pattern = patterns[indexer];
        if (pattern == null) {
            return null;
        }
        return HtmlEncoder.escape(pattern, text, description, shortcut);
    }

    protected void buttonCreated(AbstractButton button) {
    }

    public AbstractButton createButton(boolean toolbar) {
        Icon icon;
        AbstractButton button;
        AbstractButton result;
        if (this.isToggle() || this.getDisplayType() == ActionDisplayType.RADIO) {
            result = this.getDisplayType() == ActionDisplayType.TOGGLE || toolbar ? new JToggleButton(this) : (this.getDisplayType() == ActionDisplayType.CHECKBOX ? new JCheckBox(this) : new JRadioButton(this));
            result.setSelected(this.isSelected());
            this.addPropertyChangeListener(new PropertyChangeListener((JToggleButton)result){
                private final /* synthetic */ JToggleButton val$result;
                {
                    this.val$result = jToggleButton;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(ActionBase.SWING_SELECTED_KEY)) {
                        Boolean newValue;
                        if (ActionBase.this.manualUpdate && !Platform.isBelowJava16()) {
                            return;
                        }
                        Boolean oldValue = (Boolean)evt.getOldValue();
                        if (!Utils.eq((Object)oldValue, (Object)(newValue = (Boolean)evt.getNewValue())) && newValue != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ActionBase.this.manualUpdate = true;
                                    val$result.setSelected(newValue);
                                    ActionBase.this.manualUpdate = false;
                                }
                            });
                        }
                    }
                }
            });
            result.addChangeListener(new ChangeListener((JToggleButton)result){
                private final /* synthetic */ JToggleButton val$result;
                {
                    this.val$result = jToggleButton;
                }

                public void stateChanged(ChangeEvent e) {
                    if (ActionBase.this.manualUpdate) {
                        return;
                    }
                    if (this.val$result.isSelected() != ActionBase.this.isSelected()) {
                        ActionBase.this.manualUpdate = true;
                        ActionBase.this.setSelected(this.val$result.isSelected());
                        ActionBase.this.manualUpdate = false;
                    }
                }
            });
            button = result;
        } else {
            button = result = new JButton(this);
        }
        button.setMnemonic(0);
        if (Platform.isBelowJava16() && toolbar) {
            icon = (Icon)super.getValue(SWING_LARGE_ICON_KEY);
            if (icon != null) {
                button.setIcon(icon);
            }
        } else if (!toolbar && (icon = (Icon)super.getValue("SmallIcon")) != null && button.getIcon() != null && button.getIcon() != icon) {
            button.setIcon(icon);
        }
        if (toolbar && UIManager.getLookAndFeel() instanceof NapkinLookAndFeel) {
            button.setPreferredSize(new Dimension(this.getIconSize() + 12, this.getIconSize() + 12));
        }
        if (Platform.isMacOsX() && toolbar) {
            button.putClientProperty("JButton.buttonType", "toolbar");
        }
        button.setToolTipText(this.getFullTooltipText(false, this.getIcon() != null && toolbar));
        if (toolbar && this.getIcon() != null) {
            button.setText(null);
        }
        if (this.keyboardShortcuts != null) {
            for (KeyStroke keyStroke : this.keyboardShortcuts) {
                AwtTools.addKeyboardShortcut(button, keyStroke);
            }
        }
        if (toolbar) {
            this.toolbarButton = button;
        }
        this.buttonCreated(button);
        return button;
    }

    protected AbstractButton getToolbarButton() {
        return this.toolbarButton;
    }

    public JMenuItem createMenuItem(MenuGroupBase group, ButtonGroup buttonGroup) {
        JMenuItem menuItem;
        if (this.isToggle() || this.getDisplayType() == ActionDisplayType.RADIO) {
            if (this.isToggle()) {
                JCheckBoxMenuItem chkMenu = new JCheckBoxMenuItem(this);
                chkMenu.setSelected(this.isSelected());
                menuItem = chkMenu;
            } else {
                menuItem = new JRadioButtonMenuItem(this);
                menuItem.setSelected(this.isSelected());
                buttonGroup.add(menuItem);
            }
            final JMenuItem menuItem0 = menuItem;
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(ActionBase.SWING_SELECTED_KEY)) {
                        Boolean newValue;
                        if (ActionBase.this.manualUpdate && !Platform.isBelowJava16()) {
                            return;
                        }
                        Boolean oldValue = (Boolean)evt.getOldValue();
                        if (!Utils.eq((Object)oldValue, (Object)(newValue = (Boolean)evt.getNewValue())) && newValue != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ActionBase.this.manualUpdate = true;
                                    menuItem0.setSelected(newValue);
                                    ActionBase.this.manualUpdate = false;
                                }
                            });
                        }
                    }
                }
            });
            menuItem0.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (menuItem0.isSelected() != ActionBase.this.isSelected()) {
                        if (ActionBase.this.manualUpdate) {
                            return;
                        }
                        ActionBase.this.manualUpdate = true;
                        ActionBase.this.setSelected(menuItem0.isSelected());
                        ActionBase.this.manualUpdate = false;
                    }
                }
            });
        } else {
            menuItem = new JMenuItem(this);
        }
        menuItem.setToolTipText(this.getFullTooltipText(true, false));
        if (this.keyboardShortcuts != null) {
            for (KeyStroke keyStroke : this.keyboardShortcuts) {
                AwtTools.addKeyboardShortcut((AbstractButton)menuItem, keyStroke);
            }
        }
        this.menuItem = menuItem;
        return menuItem;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public static void cleanup() {
        threadPool.shutdownNow();
    }

    @Override
    public boolean isCategory() {
        return false;
    }

    @Override
    public List<IToolboxItem> getChildren() {
        return null;
    }

    @Override
    public void putValue(final String key, final Object newValue) {
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                ActionBase.super.putValue(key, newValue);
            }
        });
    }

    @Override
    public void setEnabled(final boolean newValue) {
        AwtTools.invokeInSwing(new Runnable(){

            public void run() {
                ActionBase.super.setEnabled(newValue);
            }
        });
    }
}

