/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.core.IToolboxItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuGroupBase
extends ActionBase {
    protected final Controller controller;
    private List<ActionBase> items = new ArrayList<ActionBase>();

    protected MenuGroupBase(Controller controller) {
        this.controller = controller;
    }

    public MenuGroupBase(Controller controller, String text) {
        this(controller);
        this.setText(text);
    }

    public MenuGroupBase(MenuGroupBase parent, String text) {
        this.controller = parent.controller;
        super.setText(text);
    }

    public MenuGroupBase addMenu(String text) {
        MenuGroupBase menu = new MenuGroupBase(this, text);
        this.addItem(menu);
        return menu;
    }

    public void addItem(ActionBase item) {
        this.items.add(item);
        item.setController(this.controller);
        item.setParent(this);
    }

    protected void addSeparator() {
        this.items.add(null);
    }

    public List<ActionBase> getItems() {
        return this.items;
    }

    public void setItems(List<ActionBase> items) {
        this.items = items;
    }

    public boolean isRadioButtonGroup() {
        return false;
    }

    @Override
    public boolean isCategory() {
        return true;
    }

    @Override
    public List<IToolboxItem> getChildren() {
        ArrayList<IToolboxItem> result = new ArrayList<IToolboxItem>();
        for (ActionBase item : this.items) {
            if (item == null) continue;
            result.add(item);
        }
        return result;
    }
}

