/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.ClipboardListener;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;

public abstract class ClipboardActionBase
extends ActionBase
implements ClipboardListener {
    private final SelectionAdapter selAdapter = new SelAdapter();
    private AudioFile currentFile;

    protected final void init() {
        this.setEnabled(false);
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                ClipboardActionBase.this.setCurrentFile(audioFile);
                ClipboardActionBase.this.updateEnabledStatus();
            }
        });
        AudioClipboard.getInstance().addClipboardListener(this);
    }

    private void setCurrentFile(AudioFile file) {
        if (this.currentFile != null) {
            this.currentFile.getSelection().removeSelectionListener(this.selAdapter);
        }
        this.currentFile = file;
        if (this.currentFile != null) {
            this.currentFile.getSelection().addSelectionListener(this.selAdapter);
        }
    }

    public void clipboardChanged(AudioClipboard clipboard) {
        this.updateEnabledStatus();
    }

    protected void updateEnabledStatus() {
        boolean enabled = false;
        AudioFile audioFile = this.getAudioFile();
        SelectionInfo selInfo = null;
        if (audioFile != null) {
            selInfo = audioFile.getSelection();
        }
        enabled = this.getEnabled(audioFile, selInfo, AudioClipboard.getInstance());
        this.setEnabled(enabled);
    }

    protected abstract boolean getEnabled(AudioFile var1, SelectionInfo var2, AudioClipboard var3);

    private class SelAdapter
    extends SelectionAdapter {
        private SelAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            if (!isAdjusting) {
                ClipboardActionBase.this.updateEnabledStatus();
            }
        }
    }
}

