/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.ClipboardActionBase;
import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.util.BitSet;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class CutAction
extends ClipboardActionBase {
    public CutAction() {
        super.setDetails("Cut", 120, 84);
        super.setTooltip("Cut the selected audio region to the clipboard");
        super.addKeyboardShortcut(65489);
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo, AudioClipboard clipboard) {
        return this.isSuitableSelection(file, selInfo);
    }

    private boolean isSuitableSelection(AudioFile file, SelectionInfo sInfo) {
        if (file == null || sInfo == null) {
            return false;
        }
        if (sInfo.getSelections().size() != 1) {
            return false;
        }
        ISelection selection = sInfo.getSelections().get(0);
        return selection.getChannels().equals(file.getAllChannelsMask());
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        progress.setAbortable(false, true);
        progress.setText("Cutting selection...", new Object[0]);
        int stepSize = CacheSizes.getAudioProcessBlockSize();
        AudioFile file = this.session.getCurrentFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        if (!this.isSuitableSelection(file, sInfo)) {
            return false;
        }
        ISelection selection = sInfo.getSelections().get(0);
        AudioFile clipboard = this.session.getClipboard().newContent(file);
        float[][] buffer = new float[1][stepSize];
        long total = sInfo.getLength();
        long done = 0L;
        if (selection instanceof TimeRangeSelection) {
            try {
                TimeRangeSelection trSel = (TimeRangeSelection)selection;
                BitSet chanSet = trSel.getChannels();
                int chan = chanSet.nextSetBit(0);
                while (chan >= 0) {
                    BitSet curChan = new BitSet();
                    curChan.set(chan);
                    long pos = trSel.getStartPosition();
                    long length = trSel.getStopPosition() - trSel.getStartPosition();
                    long clipPos = 0L;
                    while (length > 0L) {
                        int amount = (int)Math.min(length, (long)stepSize);
                        audio.read(curChan, pos, buffer, amount);
                        audio.delete(curChan, pos, amount);
                        clipboard.getData().write(curChan, clipPos, buffer, amount);
                        clipPos += (long)amount;
                        length -= (long)amount;
                        progress.setProgress(done += (long)amount, total);
                    }
                    chan = chanSet.nextSetBit(chan + 1);
                }
                clipboard.getData().commit();
                audio.commit();
            }
            catch (OperationAbortedException ex) {
                audio.rollback(progress);
                clipboard.getData().rollback(progress);
            }
            catch (Exception ex) {
                Debug.error((Throwable)ex);
                audio.rollback(progress);
                clipboard.getData().rollback(progress);
            }
        }
        this.session.getClipboard().contentUpdated(progress);
        sInfo.clear();
        file.getView().ensureCoherent();
        return true;
    }
}

