/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.SelectionActionBase;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.util.BitSet;
import javax.swing.KeyStroke;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class DeleteAction
extends SelectionActionBase {
    public DeleteAction() {
        super.setText("Delete");
        super.setTooltip("Delete the selected audio region");
        super.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        super.setMnemonic(68);
        this.setEnabled(false);
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo) {
        return this.isSuitableSelection(file, selInfo);
    }

    private boolean isSuitableSelection(AudioFile file, SelectionInfo sInfo) {
        if (file == null || sInfo == null) {
            return false;
        }
        if (sInfo.getSelections().size() != 1) {
            return false;
        }
        ISelection selection = sInfo.getSelections().get(0);
        return selection.getChannels().equals(file.getAllChannelsMask());
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        progress.setAbortable(false, true);
        progress.setText("Deleting selection...", new Object[0]);
        int stepSize = CacheSizes.getAudioProcessBlockSize();
        AudioFile file = this.session.getCurrentFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        if (sInfo.getSelections().size() != 1) {
            return false;
        }
        ISelection selection = sInfo.getSelections().get(0);
        long total = sInfo.getLength();
        long done = 0L;
        if (selection instanceof TimeRangeSelection) {
            try {
                TimeRangeSelection trSel = (TimeRangeSelection)selection;
                BitSet chanSet = trSel.getChannels();
                long pos = trSel.getStartPosition();
                long length = trSel.getStopPosition() - trSel.getStartPosition();
                while (length > 0L) {
                    int amount = (int)Math.min(length, (long)stepSize);
                    audio.delete(chanSet, pos, amount);
                    length -= (long)amount;
                    progress.setProgress(done += (long)(chanSet.cardinality() * amount), total);
                }
                audio.commit();
                Message.success("Selection deleted", new Object[0]);
                sInfo.clear();
                file.getView().ensureCoherent();
            }
            catch (OperationAbortedException ex) {
                audio.rollback(progress);
            }
            catch (Exception ex) {
                Debug.error((Throwable)ex);
                audio.rollback(progress);
            }
        }
        return true;
    }
}

