/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.audio.AudioFileListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.corebounce.common.utils.IProgressMonitor;

public abstract class HistoryActionBase
extends ActionBase
implements AudioChannelListener,
AudioFileListener {
    private AudioFile currentFile;

    public HistoryActionBase(Controller controller) {
        if (controller != null) {
            super.setController(controller);
        }
        this.setEnabled(false);
    }

    public HistoryActionBase(Session session) {
        if (session != null) {
            super.setSession(session);
        }
        this.setEnabled(false);
    }

    protected final void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                HistoryActionBase.this.setCurrentFile(audioFile);
                HistoryActionBase.this.updateEnabledStatus();
            }
        });
    }

    public void channelAdded(AudioFile file, AudioChannel channel) {
        channel.addAudioChannelListener(this);
        this.updateEnabledStatus();
    }

    public void channelRemoved(AudioFile file, AudioChannel channel) {
        channel.removeAudioChannelListener(this);
        this.updateEnabledStatus();
    }

    public void channelExchanged(AudioFile file, AudioChannel channel1, AudioChannel channel2) {
        this.updateEnabledStatus();
    }

    public void fileSaved(AudioFile file) {
        this.updateEnabledStatus();
    }

    public void transactionStateChanged(AudioChannel channel, boolean running) {
        this.updateEnabledStatus();
    }

    public void dataModified(AudioChannel channel, long startPos, long stopPos) {
        this.updateEnabledStatus();
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
    }

    protected final void updateEnabledStatus() {
        boolean enabled = false;
        AudioFile audioFile = this.getAudioFile();
        if (audioFile != null) {
            enabled = this.getEnabled(audioFile);
        }
        this.setEnabled(enabled);
    }

    protected abstract boolean getEnabled(AudioFile var1);

    private void setCurrentFile(AudioFile file) {
        AudioFile previous = this.currentFile;
        if (this.currentFile != null) {
            this.currentFile.removeAudioFileListener(this);
            for (AudioChannel channel : this.currentFile.getData().getChannels()) {
                channel.removeAudioChannelListener(this);
            }
        }
        this.currentFile = file;
        if (this.currentFile != null) {
            this.currentFile.addAudioFileListener(this);
            for (AudioChannel channel : this.currentFile.getData().getChannels()) {
                channel.addAudioChannelListener(this);
            }
        }
        this.currentFileChanged(previous, this.currentFile);
    }

    protected void currentFileChanged(AudioFile previous, AudioFile current) {
    }

    protected String getProgressTitle() {
        if (this.currentFile != null && this.currentFile.getFile() != null) {
            return this.currentFile.getFile().getName();
        }
        return super.getProgressTitle();
    }

    protected String getActionName() {
        String result = this.getClass().getSimpleName();
        if (result.endsWith("Action")) {
            result = result.substring(0, result.length() - "Action".length());
        }
        return result;
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        AudioFile file = this.getAudioFile();
        if (file == null) {
            return false;
        }
        progress.setText(this.getActionName(), new Object[0]);
        this.process(file, progress);
        return false;
    }

    protected abstract void process(AudioFile var1, IProgressMonitor var2) throws IOException;
}

