/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.HistoryActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import java.util.BitSet;
import org.corebounce.common.utils.IProgressMonitor;

public class RedoAction
extends HistoryActionBase {
    public RedoAction(Session session) {
        super(session);
        super.setDetails("Redo", 121, 82);
        super.setTooltip("Redo the next transformation");
        super.addKeyboardShortcut(65481);
    }

    protected boolean getEnabled(AudioFile file) {
        try {
            return file.getData().canRedo();
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
            return false;
        }
    }

    protected void preProcessSelection(AudioFile audioFile) {
    }

    protected void postProcessSelection(AudioFile audioFile) {
        audioFile.restoreSelectionFromHistory(1);
    }

    protected void process(AudioFile file, IProgressMonitor progress) throws IOException {
        if (!file.getData().canRedo()) {
            return;
        }
        progress.setAbortable(false, false);
        LongRange range = new LongRange();
        BitSet chanMask = new BitSet();
        file.getData().redo(progress, range, chanMask);
        file.getSelection().cleanup();
        file.getView().ensureCoherent();
    }
}

