/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.SelectionActionBase;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;
import java.awt.event.ActionEvent;

public class SelectVisibleAction
extends SelectionActionBase
implements AudioFileViewListener {
    public SelectVisibleAction() {
        super.setDetails("Select Visible", 86, 86);
        super.setTooltip("Select the currently displayed audio range");
        this.setEnabled(false);
    }

    protected void currentFileChanged(AudioFile audioFile) {
        if (this.currentFile != null) {
            this.currentFile.getView().removeViewListener(this);
        }
        this.currentFile = audioFile;
        if (this.currentFile != null) {
            this.currentFile.getView().addViewListener(this);
        }
    }

    public void viewChanged(AudioDataView view) {
        this.updateEnabledStatus();
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        this.updateEnabledStatus();
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo) {
        TimeRangeSelection trs;
        ISelection selection;
        if (file == null || selInfo == null) {
            return false;
        }
        AudioDataView view = file.getView();
        return selInfo.getSelections().size() != 1 || !((selection = selInfo.getSelections().get(0)) instanceof TimeRangeSelection) || (trs = (TimeRangeSelection)selection).getStartPosition() != view.getStartPosition() || trs.getStopPosition() != view.getStopPosition();
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioDataView view = this.currentFile.getView();
        SelectionInfo info = this.currentFile.getSelection();
        info.clear();
        TimeRangeSelection selection = new TimeRangeSelection(info, Math.max(0L, view.getStartPosition()), Math.min(this.currentFile.getLength(), view.getStopPosition()), this.currentFile.getAllChannelsMask());
        info.addSelection(selection);
        info.setCursorPosition(view.getStartPosition());
        return false;
    }
}

