/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;

public abstract class SelectionActionBase
extends ActionBase {
    private final SelectionAdapter selAdapter = new SelAdapter();
    protected AudioFile currentFile = null;

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                if (SelectionActionBase.this.currentFile != null) {
                    SelectionActionBase.this.currentFile.getSelection().removeSelectionListener(SelectionActionBase.this.selAdapter);
                }
                SelectionActionBase.this.currentFile = audioFile;
                if (SelectionActionBase.this.currentFile != null) {
                    SelectionActionBase.this.currentFile.getSelection().addSelectionListener(SelectionActionBase.this.selAdapter);
                }
                SelectionActionBase.this.currentFileChanged(audioFile);
                SelectionActionBase.this.updateEnabledStatus();
            }
        });
    }

    protected void currentFileChanged(AudioFile audioFile) {
    }

    protected final void updateEnabledStatus() {
        SelectionInfo selInfo = null;
        if (this.currentFile != null) {
            selInfo = this.currentFile.getSelection();
        }
        boolean enabled = this.getEnabled(this.currentFile, selInfo);
        this.setEnabled(enabled);
    }

    protected void preProcessSelection(AudioFile audioFile) {
    }

    protected abstract boolean getEnabled(AudioFile var1, SelectionInfo var2);

    private class SelAdapter
    extends SelectionAdapter {
        private SelAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            if (!isAdjusting) {
                SelectionActionBase.this.updateEnabledStatus();
            }
        }
    }
}

