/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.SelectionActionBase;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.BitSet;
import javax.swing.KeyStroke;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class SilenceAction
extends SelectionActionBase {
    public SilenceAction() {
        super.setDetails("Silence", 83);
        super.setAccelerator(KeyStroke.getKeyStroke(127, SilenceAction.getMenuModifier()));
        super.setTooltip("Replace the selection with silence");
        this.setEnabled(false);
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo) {
        if (file == null || selInfo == null || selInfo.isEmpty()) {
            return false;
        }
        for (ISelection selection : selInfo.getSelections()) {
            if (selection instanceof TimeRangeSelection) continue;
            return false;
        }
        return true;
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return this.processIterateOnChans(e, progress);
    }

    protected boolean processIterateOnChans(ActionEvent e, IProgressMonitor progress) throws Exception {
        int blockSize = CacheSizes.getAudioProcessBlockSize();
        AudioFile file = this.session.getCurrentFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        long total = sInfo.getLength();
        long done = 0L;
        ArrayList<ISelection> processed = new ArrayList<ISelection>();
        long processedStart = 0L;
        long processedStop = 0L;
        BitSet processedChanSet = new BitSet();
        try {
            for (ISelection selection : sInfo.getSelections()) {
                if (!(selection instanceof TimeRangeSelection)) continue;
                TimeRangeSelection trSel = (TimeRangeSelection)selection;
                long start = trSel.getStartPosition();
                long length = trSel.getStopPosition() - trSel.getStartPosition();
                BitSet chanSet = trSel.getChannels();
                processedStart = start;
                processedStop = start;
                float[][] zeros = new float[1][blockSize];
                int chan = chanSet.nextSetBit(0);
                while (chan >= 0) {
                    BitSet curChan = new BitSet();
                    curChan.set(chan);
                    processedChanSet.set(chan);
                    long pos = start;
                    long remaining = length;
                    while (remaining > 0L) {
                        int amount = (int)Math.min((long)blockSize, remaining);
                        audio.write(curChan, pos, zeros, amount);
                        remaining -= (long)amount;
                        processedStop = pos += (long)amount;
                        progress.setProgress(done += (long)amount, total);
                    }
                    chan = chanSet.nextSetBit(chan + 1);
                }
                TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, processedStart, processedStop, processedChanSet);
                processed.add(curProcessed);
            }
            audio.commit();
            Message.success("Silence applied", new Object[0]);
        }
        catch (OperationAbortedException ex) {
            if (ex.isCancel()) {
                audio.rollback(progress);
            } else {
                audio.commit();
                if (processedStop > processedStart) {
                    TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, processedStart, processedStop, processedChanSet);
                    processed.add(curProcessed);
                }
                file.getSelection().clear();
                file.getSelection().addSelections(processed);
            }
        }
        catch (Exception ex) {
            Debug.error((Throwable)ex);
            audio.rollback(progress);
        }
        return false;
    }

    protected boolean processAllChansTogether(ActionEvent e, IProgressMonitor progress) throws Exception {
        int blockSize = CacheSizes.getAudioProcessBlockSize();
        AudioFile file = this.session.getCurrentFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        long total = sInfo.getLength();
        long done = 0L;
        ArrayList<ISelection> processed = new ArrayList<ISelection>();
        long processedStart = 0L;
        long processedStop = 0L;
        BitSet processedChanSet = new BitSet();
        try {
            for (ISelection selection : sInfo.getSelections()) {
                if (!(selection instanceof TimeRangeSelection)) continue;
                TimeRangeSelection trSel = (TimeRangeSelection)selection;
                long start = trSel.getStartPosition();
                long length = trSel.getStopPosition() - trSel.getStartPosition();
                BitSet chanSet = trSel.getChannels();
                processedStart = start;
                processedStop = start;
                processedChanSet = chanSet;
                int nbChannels = chanSet.cardinality();
                float[][] zeros = new float[nbChannels][blockSize];
                long pos = start;
                long remaining = length;
                while (remaining > 0L) {
                    int amount = (int)Math.min((long)blockSize, remaining);
                    audio.write(chanSet, pos, zeros, amount);
                    remaining -= (long)amount;
                    processedStop = pos += (long)amount;
                    progress.setProgress(done += (long)(amount * nbChannels), total);
                }
                TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, processedStart, processedStop, processedChanSet);
                processed.add(curProcessed);
            }
            audio.commit();
        }
        catch (OperationAbortedException ex) {
            if (ex.isCancel()) {
                audio.rollback(progress);
            }
            audio.commit();
            if (processedStop > processedStart) {
                TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, processedStart, processedStop, processedChanSet);
                processed.add(curProcessed);
            }
            file.getSelection().clear();
            file.getSelection().addSelections(processed);
        }
        return false;
    }
}

