/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.SelectionActionBase;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleSelectionAction
extends SelectionActionBase {
    public ToggleSelectionAction() {
        super.setDetails("Toggle Selection", 103, 71);
        super.setTooltip("Select all deselected parts");
        this.setEnabled(false);
    }

    @Override
    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo) {
        return file != null;
    }

    @Override
    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        long curStart = 0L;
        SelectionInfo info = this.currentFile.getSelection();
        List<ISelection> selections = info.getSelections();
        ArrayList<TimeRangeSelection> newSelections = new ArrayList<TimeRangeSelection>();
        while (curStart < this.currentFile.getLength()) {
            long l = this.getNextHotPos(selections, curStart);
            if (!this.isSelected(selections, curStart, l)) {
                TimeRangeSelection trs = new TimeRangeSelection(info, curStart, l, this.currentFile.getAllChannelsMask());
                newSelections.add(trs);
            }
            curStart = l;
        }
        info.clear();
        for (ISelection iSelection : newSelections) {
            info.addSelection(iSelection);
        }
        return false;
    }

    private long getNextHotPos(List<ISelection> selections, long fromPos) {
        long result = this.currentFile.getLength();
        for (ISelection selection : selections) {
            if (selection.getBoundingStartPosition() > fromPos) {
                result = Math.min(result, selection.getBoundingStartPosition());
            }
            if (selection.getBoundingStopPosition() <= fromPos) continue;
            result = Math.min(result, selection.getBoundingStopPosition());
        }
        return result;
    }

    private boolean isSelected(List<ISelection> selections, long start, long stop) {
        for (ISelection selection : selections) {
            long selStart = selection.getBoundingStartPosition();
            long selStop = selection.getBoundingStopPosition();
            if (selStart >= stop || selStop <= start) continue;
            return true;
        }
        return false;
    }
}

