/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit;

import ch.tachyon.sonics.action.edit.HistoryActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.memory.undoredo.LongRange;
import ch.tachyon.tunnel.utils.Debug;
import java.io.IOException;
import java.util.BitSet;
import org.corebounce.common.utils.IProgressMonitor;

public class UndoAction
extends HistoryActionBase {
    private int selectionHistoryDelta;

    public UndoAction(Session session) {
        super(session);
        super.setDetails("Undo", 122, 85);
        super.setTooltip("Undo the last transformation");
        super.addKeyboardShortcut(65483);
    }

    protected boolean getEnabled(AudioFile file) {
        try {
            return file.getData().canUndo();
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
            return false;
        }
    }

    protected void preProcessSelection(AudioFile audioFile) {
        this.selectionHistoryDelta = -1;
        try {
            if (!audioFile.getData().canRedo()) {
                audioFile.addCurrentSelectionToHistory();
                this.selectionHistoryDelta = -2;
            }
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
    }

    protected void postProcessSelection(AudioFile audioFile) {
        audioFile.restoreSelectionFromHistory(this.selectionHistoryDelta);
    }

    protected void process(AudioFile file, IProgressMonitor progress) throws IOException {
        if (!file.getData().canUndo()) {
            return;
        }
        progress.setAbortable(false, false);
        LongRange range = new LongRange();
        BitSet chanMask = new BitSet();
        file.getData().undo(progress, range, chanMask);
        file.getSelection().cleanup();
        file.getView().ensureCoherent();
    }
}

