/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit.pastespecial;

import ch.tachyon.sonics.action.edit.ClipboardActionBase;
import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.util.BitSet;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class MixPasteAction
extends ClipboardActionBase {
    public MixPasteAction() {
        super.setDetails("Mix Paste", 109, 77);
        super.setTooltip("Mix the clipboard content with current file, starting from the cursor position.");
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo, AudioClipboard clipboard) {
        return this.isSuitableForPaste(clipboard, file);
    }

    private boolean isSuitableForPaste(AudioClipboard clipboard, AudioFile file) {
        if (!clipboard.hasAudioContent() || file == null) {
            return false;
        }
        AudioFile localContent = clipboard.getLocalContent();
        if (localContent != null) {
            return localContent.getNbChannels() == file.getNbChannels();
        }
        return true;
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        progress.setAbortable(false, true);
        AudioFile clipboard = this.session.getClipboard().getContent(progress);
        if (clipboard == null) {
            return false;
        }
        if (clipboard.getNbChannels() != this.getAudioFile().getNbChannels()) {
            Message.error("Cannot paste audio clip because the number of channels does not match", new Object[0]);
            return false;
        }
        progress.setText("Mixing clipboard content...", new Object[0]);
        AudioFile file = this.getAudioFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        long done = 0L;
        long total = clipboard.getLength() * (long)clipboard.getNbChannels();
        try {
            this.mixClipboardContent(audio, clipboard, sInfo.getCursorPosition(), progress, done, total);
            audio.commit();
            sInfo.clear();
            TimeRangeSelection trSel = new TimeRangeSelection(sInfo, sInfo.getCursorPosition(), sInfo.getCursorPosition() + clipboard.getLength(), file.getAllChannelsMask());
            sInfo.addSelection(trSel);
        }
        catch (OperationAbortedException ex) {
            audio.rollback(progress);
            clipboard.getData().rollback(progress);
        }
        catch (Exception ex) {
            Debug.error((Throwable)ex);
            audio.rollback(progress);
            clipboard.getData().rollback(progress);
        }
        return true;
    }

    private void mixClipboardContent(AudioChannels audio, AudioFile clipboard, long startPos, IProgressMonitor progress, long done, long total) throws Exception {
        int stepSize = CacheSizes.getAudioProcessBlockSize();
        float[][] srcBuffer = new float[1][stepSize];
        float[][] dstBuffer = new float[1][stepSize];
        BitSet chanSet = clipboard.getAllChannelsMask();
        int chan = chanSet.nextSetBit(0);
        while (chan >= 0) {
            BitSet curChan = new BitSet();
            curChan.set(chan);
            long clipPos = 0L;
            long filePos = startPos;
            long maxPos = audio.getChannel(chan, true).getLength();
            long length = clipboard.getLength();
            while (length > 0L) {
                int amount = (int)Math.min(length, (long)stepSize);
                if (filePos < maxPos && filePos + (long)amount > maxPos) {
                    amount = (int)(maxPos - filePos);
                }
                clipboard.getData().read(curChan, clipPos, srcBuffer, amount);
                if (filePos < maxPos) {
                    audio.read(curChan, filePos, dstBuffer, amount);
                    int i = 0;
                    while (i < amount) {
                        float[] fArray = srcBuffer[0];
                        int n = i;
                        fArray[n] = fArray[n] + dstBuffer[0][i];
                        ++i;
                    }
                    audio.write(curChan, filePos, srcBuffer, amount);
                } else {
                    audio.insert(curChan, filePos, srcBuffer, amount);
                }
                filePos += (long)amount;
                clipPos += (long)amount;
                length -= (long)amount;
                progress.setProgress(done += (long)amount, total);
            }
            chan = chanSet.nextSetBit(chan + 1);
        }
    }
}

