/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit.pastespecial;

import ch.tachyon.sonics.action.edit.PasteAction;
import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import org.corebounce.common.utils.IProgressMonitor;

public class PasteNewFileAction
extends PasteAction {
    private AudioFile newFile = null;

    public PasteNewFileAction() {
        super(false);
        super.setDetails("Paste Into New File", 70, 70);
        super.setTooltip("Create a new audio file with the clipboard content");
    }

    protected AudioFile getAudioFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        return super.getAudioFile();
    }

    protected boolean isSuitableForPaste(AudioClipboard clipboard, AudioFile file) {
        return clipboard.hasAudioContent();
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        AudioFile clipboardFile = AudioClipboard.getInstance().getContent(progress);
        if (clipboardFile == null) {
            return false;
        }
        this.newFile = new AudioFile();
        this.newFile.copyAttributesFrom(clipboardFile);
        int i = 0;
        while (i < clipboardFile.getNbChannels()) {
            this.newFile.getData().addChannel(i);
            ++i;
        }
        super.paste(progress, clipboardFile);
        this.newFile.getData().baseUndoRedoPoint();
        Session session = this.controller.getSession();
        session.setCurrentFile(this.newFile);
        session.addFile(this.newFile);
        this.newFile = null;
        return true;
    }
}

