/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.edit.pastespecial;

import ch.tachyon.sonics.action.edit.ClipboardActionBase;
import ch.tachyon.sonics.data.AudioClipboard;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.audio.AudioChannels;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.util.BitSet;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class SwapAction
extends ClipboardActionBase {
    public SwapAction() {
        super.setDetails("Swap", 66, 83);
        super.setTooltip("Swap current selection with clipboard content");
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo, AudioClipboard clipboard) {
        return this.isSuitableForPaste(clipboard, file) && this.isSuitableForCut(file, selInfo);
    }

    private boolean isSuitableForPaste(AudioClipboard clipboard, AudioFile file) {
        if (!clipboard.hasAudioContent() || file == null) {
            return false;
        }
        AudioFile localContent = clipboard.getLocalContent();
        if (localContent != null) {
            return localContent.getNbChannels() == file.getNbChannels();
        }
        return true;
    }

    private boolean isSuitableForCut(AudioFile file, SelectionInfo sInfo) {
        if (file == null || sInfo == null) {
            return false;
        }
        if (sInfo.getSelections().size() != 1) {
            return false;
        }
        ISelection selection = sInfo.getSelections().get(0);
        return selection.getChannels().equals(file.getAllChannelsMask());
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        progress.setAbortable(false, true);
        AudioFile clipboard = this.session.getClipboard().getContent(progress);
        if (clipboard == null) {
            return false;
        }
        if (clipboard.getNbChannels() != this.getAudioFile().getNbChannels()) {
            Message.error("Cannot paste audio clip because the number of channels does not match", new Object[0]);
            return false;
        }
        progress.setText("Swapping selection with clipboard content...", new Object[0]);
        AudioFile file = this.getAudioFile();
        AudioChannels audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        TimeRangeSelection selection = (TimeRangeSelection)sInfo.getSelections().get(0);
        long done = 0L;
        long total = (clipboard.getLength() + (selection.getStopPosition() - selection.getStartPosition())) * (long)clipboard.getNbChannels();
        long clipboardLength = clipboard.getLength();
        try {
            done = this.insertClipboardContent(audio, clipboard, selection.getStopPosition(), progress, done, total);
            audio.flush();
            this.cutSelection(file, selection, done, total, progress);
            audio.commit();
            sInfo.clear();
            TimeRangeSelection trSel = new TimeRangeSelection(sInfo, sInfo.getCursorPosition(), sInfo.getCursorPosition() + clipboardLength, file.getAllChannelsMask());
            sInfo.addSelection(trSel);
        }
        catch (OperationAbortedException ex) {
            audio.rollback(progress);
            clipboard.getData().rollback(progress);
        }
        catch (Exception ex) {
            Debug.error((Throwable)ex);
            audio.rollback(progress);
            clipboard.getData().rollback(progress);
        }
        this.session.getClipboard().contentUpdated(progress);
        return true;
    }

    private long insertClipboardContent(AudioChannels audio, AudioFile clipboard, long pos, IProgressMonitor progress, long done, long total) throws Exception {
        int stepSize = CacheSizes.getAudioProcessBlockSize();
        float[][] buffer = new float[1][stepSize];
        BitSet chanSet = clipboard.getAllChannelsMask();
        int chan = chanSet.nextSetBit(0);
        while (chan >= 0) {
            BitSet curChan = new BitSet();
            curChan.set(chan);
            long clipPos = 0L;
            long filePos = pos;
            long length = clipboard.getLength();
            while (length > 0L) {
                int amount = (int)Math.min(length, (long)stepSize);
                clipboard.getData().read(curChan, clipPos, buffer, amount);
                audio.insert(curChan, filePos, buffer, amount);
                filePos += (long)amount;
                clipPos += (long)amount;
                length -= (long)amount;
                progress.setProgress(done += (long)amount, total);
            }
            chan = chanSet.nextSetBit(chan + 1);
        }
        return done;
    }

    private void cutSelection(AudioFile file, TimeRangeSelection trSel, long done, long total, IProgressMonitor progress) throws Exception {
        AudioFile clipboard = this.session.getClipboard().newContent(file);
        AudioChannels audio = file.getData();
        BitSet chanSet = trSel.getChannels();
        int stepSize = CacheSizes.getAudioProcessBlockSize();
        float[][] buffer = new float[1][stepSize];
        int chan = chanSet.nextSetBit(0);
        while (chan >= 0) {
            BitSet curChan = new BitSet();
            curChan.set(chan);
            long pos = trSel.getStartPosition();
            long length = trSel.getStopPosition() - trSel.getStartPosition();
            long clipPos = 0L;
            while (length > 0L) {
                int amount = (int)Math.min(length, (long)stepSize);
                audio.read(curChan, pos, buffer, amount);
                audio.delete(curChan, pos, amount);
                clipboard.getData().write(curChan, clipPos, buffer, amount);
                clipPos += (long)amount;
                length -= (long)amount;
                progress.setProgress(done += (long)amount, total);
            }
            chan = chanSet.nextSetBit(chan + 1);
        }
        clipboard.getData().commit();
    }
}

