/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.effect;

import ch.tachyon.sonics.action.effect.EffectActionBase;
import ch.tachyon.sonics.action.effect.SelectionProcessContext;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.utils.AntiDelayBuffer;
import ch.tachyon.tunnel.host.ISimpleEffect;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyMultiChanEffectAction
extends EffectActionBase<ISimpleEffect> {
    public ApplyMultiChanEffectAction(Effect effect) {
        super(effect, ISimpleEffect.class);
    }

    @Override
    protected boolean changesSelection() {
        return false;
    }

    @Override
    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return super.processAllChansTogether(progress);
    }

    @Override
    protected void processSelectionAllChans(IProgressMonitor progress, SelectionProcessContext context) throws IOException, OperationAbortedException {
        int chunkLength = this.getProcessingChunkLength();
        int latency = ((ISimpleEffect)this.effectInstance).getLatency();
        context.total += (long)(latency * context.nbChannels);
        AntiDelayBuffer[] compensators = null;
        if (latency > 0) {
            compensators = new AntiDelayBuffer[context.nbChannels];
            int c = 0;
            while (c < context.nbChannels) {
                compensators[c] = new AntiDelayBuffer(latency, chunkLength);
                ++c;
            }
        }
        float[][] buffer = new float[context.nbChannels][chunkLength];
        long readPos = context.start;
        long writePos = context.start;
        long dstRemaining = context.length;
        long srcRemaining = context.length;
        while (dstRemaining > 0L) {
            int amount = (int)Math.min((long)chunkLength, dstRemaining);
            int toRead = (int)Math.min((long)amount, srcRemaining);
            int toPad = amount - toRead;
            if (toRead > 0) {
                context.audio.read(context.curChanSet, readPos, buffer, amount);
            }
            if (toPad > 0) {
                int c = 0;
                while (c < buffer.length) {
                    Arrays.fill(buffer[c], toRead, chunkLength, 0.0f);
                    ++c;
                }
            }
            ((ISimpleEffect)this.effectInstance).process(buffer);
            boolean outputAvailable = true;
            if (compensators != null) {
                int c = 0;
                while (c < context.nbChannels) {
                    outputAvailable = compensators[c].process(buffer[c]);
                    ++c;
                }
            }
            if (outputAvailable) {
                assert (writePos < context.start + context.length);
                context.audio.write(context.curChanSet, writePos, buffer, amount);
                writePos += (long)amount;
                dstRemaining -= (long)amount;
            }
            srcRemaining -= (long)toRead;
            context.processedStop = readPos += (long)amount;
            progress.setProgress((context.done + ((ISimpleEffect)this.effectInstance).getProcessedFrames()) * (long)context.nbChannels, context.total);
        }
    }
}

