/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.effect;

import ch.tachyon.sonics.action.effect.EffectActionBase;
import ch.tachyon.sonics.action.effect.SelectionProcessContext;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.data.audio.ParallelReadDeleteInsert;
import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.host.IPushEffect;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyMultiChanPushEffectAction
extends EffectActionBase<IPushEffect>
implements IMultiChanAudioSink {
    private SelectionProcessContext context;
    private ParallelReadDeleteInsert ioProcessor;
    private volatile boolean aborted = false;
    private int ignoreHead = 0;

    public ApplyMultiChanPushEffectAction(Effect effect) {
        super(effect, IPushEffect.class);
    }

    public void writeSamples(float[][] samples) {
        if (this.aborted) {
            return;
        }
        float[][] source = samples;
        if (this.ignoreHead > 0) {
            int amount = Math.min(this.ignoreHead, samples.length);
            this.ignoreHead -= amount;
            if (amount < samples[0].length) {
                float[][] rem = new float[samples.length][samples[0].length - amount];
                int c = 0;
                while (c < samples.length) {
                    System.arraycopy(samples[c], amount, rem[c], 0, samples[0].length - amount);
                    ++c;
                }
                source = rem;
            }
        }
        try {
            if (source != null) {
                this.ioProcessor.insertNext(source);
                this.context.processedStop += (long)source[0].length;
            }
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
    }

    @Override
    protected boolean changesSelection() {
        return true;
    }

    @Override
    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return super.processAllChansTogether(progress);
    }

    @Override
    protected void processSelectionAllChans(IProgressMonitor progress, SelectionProcessContext context) throws IOException, OperationAbortedException {
        this.context = context;
        long readPos = context.start;
        int nbChans = context.nbChannels;
        int chunkLength = super.getProcessingChunkLength();
        long additionalFrames = ((IPushEffect)this.effectInstance).getAdditionalInputFrames();
        this.aborted = false;
        float[][] buffer = new float[nbChans][chunkLength];
        Platform.lowerPriority();
        try {
            try {
                int actual;
                if (((IPushEffect)this.effectInstance).getRequiredSamplesBefore() > 0L) {
                    int requiredBefore = (int)((IPushEffect)this.effectInstance).getRequiredSamplesBefore();
                    if ((long)requiredBefore > context.start) {
                        requiredBefore = (int)context.start;
                    }
                    requiredBefore -= requiredBefore % chunkLength;
                    this.ignoreHead = (int)((float)requiredBefore * ((IPushEffect)this.effectInstance).getTimeChange() + 0.5f);
                    while (requiredBefore > 0) {
                        int amount = Math.min(chunkLength, requiredBefore);
                        float[][] beforeBuffer = new float[nbChans][amount];
                        context.audio.read(context.curChanSet, context.start - (long)requiredBefore, beforeBuffer, amount);
                        ((IPushEffect)this.effectInstance).process(beforeBuffer, amount, (IMultiChanAudioSink)this);
                        requiredBefore -= amount;
                    }
                }
                this.ioProcessor = new ParallelReadDeleteInsert(context.audio, context.curChanSet, chunkLength, context.start, context.length);
                do {
                    actual = (int)Math.min((long)chunkLength, context.start + context.length - readPos);
                    this.ioProcessor.readDeleteNext(buffer);
                    ((IPushEffect)this.effectInstance).process(buffer, actual, (IMultiChanAudioSink)this);
                    readPos += (long)actual;
                    progress.setProgress((context.done + ((IPushEffect)this.effectInstance).getProcessedFrames()) * (long)context.nbChannels, context.total + additionalFrames);
                } while (actual == chunkLength);
            }
            catch (OperationAbortedException ex) {
                this.aborted = true;
                ((IPushEffect)this.effectInstance).process(buffer, 0, (IMultiChanAudioSink)this);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            if (this.ioProcessor != null) {
                this.ioProcessor.dispose();
            }
            this.ioProcessor = null;
            Debug.info((String)"{0} --> {1}", (Object[])new Object[]{context.length, context.processedStop - context.start});
            this.context = null;
            Platform.normalPriority();
            throw throwable;
        }
        if (this.ioProcessor != null) {
            this.ioProcessor.dispose();
        }
        this.ioProcessor = null;
        Debug.info((String)"{0} --> {1}", (Object[])new Object[]{context.length, context.processedStop - context.start});
        this.context = null;
        Platform.normalPriority();
    }
}

