/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.effect;

import ch.tachyon.sonics.action.effect.EffectActionBase;
import ch.tachyon.sonics.action.effect.SelectionProcessContext;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.data.audio.ParallelReadDeleteInsert;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyPushEffectAction
extends EffectActionBase<ISingleChanPushEffect>
implements ISingleChanAudioSink {
    private SelectionProcessContext context;
    private float[][] mcSource;
    private ParallelReadDeleteInsert ioProcessor;
    private volatile boolean aborted = false;
    private int ignoreHead = 0;

    public ApplyPushEffectAction(Effect effect) {
        super(effect, ISingleChanPushEffect.class);
    }

    public void writeSamples(float[] samples) {
        if (this.aborted) {
            return;
        }
        if (this.mcSource == null) {
            this.mcSource = new float[1][];
        }
        if (this.ignoreHead > 0) {
            int amount = Math.min(this.ignoreHead, samples.length);
            this.ignoreHead -= amount;
            this.mcSource[0] = null;
            if (amount < samples.length) {
                float[] rem = new float[samples.length - amount];
                System.arraycopy(samples, amount, rem, 0, samples.length - amount);
                this.mcSource[0] = rem;
            }
        } else {
            this.mcSource[0] = samples;
        }
        try {
            if (this.mcSource[0] != null) {
                this.ioProcessor.insertNext(this.mcSource);
                this.context.processedStop += (long)this.mcSource[0].length;
            }
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
    }

    @Override
    protected boolean changesSelection() {
        return true;
    }

    @Override
    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return super.processChanByChan(progress);
    }

    @Override
    protected void processSelectionOneChan(SelectionProcessContext context, IProgressMonitor progress) throws IOException, OperationAbortedException {
        this.context = context;
        long readPos = context.start;
        int chunkLength = super.getProcessingChunkLength();
        long additionalFrames = ((ISingleChanPushEffect)this.effectInstance).getAdditionalInputFrames() * (long)context.nbChannels;
        this.aborted = false;
        float[] buffer = new float[chunkLength];
        float[][] mcBuffer = new float[1][];
        try {
            try {
                int actual;
                if (((ISingleChanPushEffect)this.effectInstance).getRequiredSamplesBefore() > 0L) {
                    int requiredBefore = (int)((ISingleChanPushEffect)this.effectInstance).getRequiredSamplesBefore();
                    if ((long)requiredBefore > context.start) {
                        requiredBefore = (int)context.start;
                    }
                    requiredBefore -= requiredBefore % chunkLength;
                    this.ignoreHead = (int)((float)requiredBefore * ((ISingleChanPushEffect)this.effectInstance).getTimeChange() + 0.5f);
                    while (requiredBefore > 0) {
                        int amount = Math.min(chunkLength, requiredBefore);
                        float[][] beforeBuffer = new float[1][amount];
                        context.audio.read(context.curChanSet, context.start - (long)requiredBefore, beforeBuffer, amount);
                        ((ISingleChanPushEffect)this.effectInstance).process(beforeBuffer[0], amount, (ISingleChanAudioSink)this);
                        requiredBefore -= amount;
                    }
                }
                this.ioProcessor = new ParallelReadDeleteInsert(context.audio, context.curChanSet, chunkLength, context.start, context.length);
                do {
                    actual = (int)Math.min((long)chunkLength, context.start + context.length - readPos);
                    mcBuffer[0] = buffer;
                    this.ioProcessor.readDeleteNext(mcBuffer);
                    ((ISingleChanPushEffect)this.effectInstance).process(buffer, actual, (ISingleChanAudioSink)this);
                    readPos += (long)actual;
                    progress.setProgress(context.done + ((ISingleChanPushEffect)this.effectInstance).getProcessedFrames(), context.total + additionalFrames);
                } while (actual == chunkLength);
            }
            catch (OperationAbortedException ex) {
                this.aborted = true;
                ((ISingleChanPushEffect)this.effectInstance).process(buffer, 0, (ISingleChanAudioSink)this);
                throw ex;
            }
        }
        finally {
            if (this.ioProcessor != null) {
                this.ioProcessor.dispose();
            }
            this.ioProcessor = null;
            this.context = null;
            this.mcSource = null;
        }
    }
}

