/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.effect;

import ch.tachyon.sonics.action.effect.EffectActionBase;
import ch.tachyon.sonics.action.effect.SelectionProcessContext;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.data.audio.DelayedWriter;
import ch.tachyon.sonics.data.audio.LookAheadReader;
import ch.tachyon.sonics.utils.AntiDelayBuffer;
import ch.tachyon.tunnel.host.ISingleChanEffect;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Arrays;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplySingleChanEffectAction
extends EffectActionBase<ISingleChanEffect> {
    public ApplySingleChanEffectAction(Effect effect) {
        super(effect, ISingleChanEffect.class);
    }

    @Override
    protected boolean changesSelection() {
        return false;
    }

    @Override
    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        return super.processChanByChan(progress);
    }

    @Override
    protected void processSelectionOneChan(SelectionProcessContext context, IProgressMonitor progress) throws IOException, OperationAbortedException {
        int chunkLength = this.getProcessingChunkLength();
        int latency = ((ISingleChanEffect)this.effectInstance).getLatency();
        if (context.chanNum == 0) {
            context.total += (long)(latency * context.allChanSet.cardinality());
        }
        AntiDelayBuffer compensator = null;
        if (latency > 0) {
            compensator = new AntiDelayBuffer(latency, chunkLength);
        }
        long pos = context.start;
        long srcRemaining = context.length;
        long dstRemaining = context.length;
        LookAheadReader reader = new LookAheadReader(context.audio, context.curChanSet, chunkLength, context.start, context.start + context.length);
        DelayedWriter writer = new DelayedWriter(context.audio, context.curChanSet, chunkLength, context.start);
        float[][] buffer = new float[1][chunkLength];
        try {
            while (dstRemaining > 0L) {
                int amount = (int)Math.min((long)chunkLength, dstRemaining);
                int toRead = (int)Math.min((long)amount, srcRemaining);
                int toPad = amount - toRead;
                if (toRead > 0) {
                    reader.readNext(buffer);
                }
                if (toPad > 0) {
                    Arrays.fill(buffer[0], toRead, chunkLength, 0.0f);
                }
                ((ISingleChanEffect)this.effectInstance).process(buffer[0]);
                boolean outputAvailable = compensator != null ? compensator.process(buffer[0]) : true;
                if (outputAvailable) {
                    writer.writeNext(buffer, amount);
                    dstRemaining -= (long)amount;
                }
                srcRemaining -= (long)toRead;
                context.processedStop = pos += (long)amount;
                progress.setProgress(context.done + ((ISingleChanEffect)this.effectInstance).getProcessedFrames(), context.total);
            }
        }
        finally {
            reader.dispose();
            writer.dispose();
        }
    }

    @Override
    public int getNumberOfChannels() {
        return 1;
    }
}

