/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.effect;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.effect.ApplyMultiChanEffectAction;
import ch.tachyon.sonics.action.effect.ApplyMultiChanPushEffectAction;
import ch.tachyon.sonics.action.effect.ApplyPullEffectAction;
import ch.tachyon.sonics.action.effect.ApplyPushEffectAction;
import ch.tachyon.sonics.action.effect.ApplySingleChanEffectAction;
import ch.tachyon.sonics.action.effect.SelectionProcessContext;
import ch.tachyon.sonics.action.transport.PlayStopAction;
import ch.tachyon.sonics.core.Effect;
import ch.tachyon.sonics.core.EffectPresets;
import ch.tachyon.sonics.data.CacheSizes;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioChannelListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.selection.TimeRangeSelection;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.IGuiListener;
import ch.tachyon.tunnel.host.IParameter;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.IPushEffect;
import ch.tachyon.tunnel.host.ISimpleEffect;
import ch.tachyon.tunnel.host.ISingleChanEffect;
import ch.tachyon.tunnel.host.ISingleChanPullEffect;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.opt.spec.Channels;
import ch.tachyon.tunnel.plugin.opt.spec.OverTime;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EffectActionBase<E extends IEffect>
extends ActionBase
implements IProcessingInfo {
    private static final String OVERLUNCH_WARNING = "<html><body>You have set the quality to the maximum value, enabling the <b>Overlunch Mode</b>.<p><p>This mode is <b><i>very slow</i></b>.<p>As its name implies it, it is only useful if you need the best quality at any price,<p>and are ready to wait for <i>several minutes to a few hours</i> of processing.<p><p>Note that to most people, there is little to no differences in quality between<p>the Overlunch Mode and the next lower quality setting.<p><p>Do you want to proceed with the slow, Overlunch Mode ?</body></html>";
    protected final Effect effect;
    protected final Class<E> effectInterface;
    private final SelectionAdapter selAdapter = new SelAdapter();
    private final AudioChannelListener chanAdapter = new AudioChannelAdapter();
    protected AudioFile currentFile = null;
    protected transient E effectInstance = null;
    protected transient TimeRangeSelection curSelection = null;
    protected transient int chunkLength;

    public EffectActionBase(Effect effect, Class<E> effectInterface) {
        this.effect = effect;
        this.effectInterface = effectInterface;
        super.setText(effect.getName());
        super.setTooltip(this.description2html(effect.getDescription()));
        this.setEnabled(false);
    }

    @Override
    protected String getFullTooltipText(boolean menu, boolean iconOnly) {
        return super.getTooltip();
    }

    private String description2html(String description) {
        if (description == null || description.trim().equals("")) {
            return null;
        }
        boolean firstLine = true;
        StringBuilder result = new StringBuilder();
        result.append("<html><body><b>");
        int i = 0;
        while (i < description.length()) {
            char ch = description.charAt(i);
            if (ch == '\n') {
                if (firstLine) {
                    result.append("</b>");
                }
                result.append("<br>");
                firstLine = false;
            } else if (ch == '<') {
                result.append("&lt;");
            } else if (ch == '>') {
                result.append("&gt;");
            } else if (ch == '\"') {
                result.append("&quot;");
            } else if (ch == '&') {
                result.append("&amp;");
            } else {
                result.append(ch);
            }
            ++i;
        }
        if (firstLine) {
            result.append("</b>");
        }
        result.append("</body></html>");
        return result.toString();
    }

    @Override
    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                if (EffectActionBase.this.currentFile != null) {
                    EffectActionBase.this.currentFile.getSelection().removeSelectionListener(EffectActionBase.this.selAdapter);
                    for (AudioChannel channel : EffectActionBase.this.currentFile.getData().getChannels()) {
                        channel.removeAudioChannelListener(EffectActionBase.this.chanAdapter);
                    }
                }
                EffectActionBase.this.currentFile = audioFile;
                if (EffectActionBase.this.currentFile != null) {
                    EffectActionBase.this.currentFile.getSelection().addSelectionListener(EffectActionBase.this.selAdapter);
                    for (AudioChannel channel : EffectActionBase.this.currentFile.getData().getChannels()) {
                        channel.addAudioChannelListener(EffectActionBase.this.chanAdapter);
                    }
                }
                EffectActionBase.this.updateEnabledStatus();
            }
        });
    }

    @Override
    protected String getActionName() {
        return this.effect.getName();
    }

    @Override
    protected String getProgressTitle() {
        if (this.currentFile != null && this.currentFile.getFile() != null) {
            return this.currentFile.getFile().getName();
        }
        return super.getProgressTitle();
    }

    protected void updateEnabledStatus() {
        SelectionInfo selInfo = null;
        if (this.currentFile != null) {
            selInfo = this.currentFile.getSelection();
        }
        boolean enabled = this.getEnabled(this.currentFile, selInfo);
        this.setEnabled(enabled);
    }

    protected boolean getEnabled(AudioFile file, SelectionInfo selInfo) {
        if (file == null || selInfo == null) {
            return false;
        }
        Channels channels = this.effect.getChannels();
        if (channels != null && (file.getNbChannels() < channels.min() || file.getNbChannels() > channels.max())) {
            return false;
        }
        SampleRates sampleRates = this.effect.getSampleRates();
        if (sampleRates != null && (file.getSampleRate() < sampleRates.min() || file.getSampleRate() > sampleRates.max())) {
            return false;
        }
        if (selInfo.isEmpty()) {
            return file.getLength() > 0L;
        }
        for (ISelection selection : selInfo.getSelections()) {
            if (selection instanceof TimeRangeSelection) continue;
            return false;
        }
        return true;
    }

    public static EffectActionBase<?> createActionFor(Effect effect) {
        Class<? extends IEffect> pluginInterface = effect.getHostInterface();
        if (pluginInterface.equals(ISimpleEffect.class)) {
            return new ApplyMultiChanEffectAction(effect);
        }
        if (pluginInterface.equals(ISingleChanEffect.class)) {
            return new ApplySingleChanEffectAction(effect);
        }
        if (pluginInterface.equals(ISingleChanPullEffect.class)) {
            return new ApplyPullEffectAction(effect);
        }
        if (pluginInterface.equals(ISingleChanPushEffect.class)) {
            return new ApplyPushEffectAction(effect);
        }
        if (pluginInterface.equals(IPushEffect.class)) {
            return new ApplyMultiChanPushEffectAction(effect);
        }
        throw new UnsupportedOperationException("Unhandled interface type: " + effect.getHostInterface());
    }

    @Override
    protected boolean preProcess(ActionEvent e) throws Exception {
        SelectionInfo selInfo = this.currentFile.getSelection();
        if (selInfo.isEmpty()) {
            TimeRangeSelection selection = new TimeRangeSelection(selInfo, 0L, this.currentFile.getLength(), this.currentFile.getAllChannelsMask());
            selInfo.addSelection(selection);
        }
        this.effectInstance = this.effect.getBundle().loadPlugin(this.effectInterface, this.effect.getClassName());
        if (this.effectInstance != null) {
            this.effectInstance.load((IProcessingInfo)this);
            try {
                EffectPresets.loadEffectSessionDefaults(this.effect.getBundle(), this.effectInstance);
            }
            catch (Exception ex) {
                Debug.warn((String)"Failed to restore the previous parameter values for effect {0}", (Object[])new Object[]{this.effect.getName()});
                Debug.warn((Throwable)ex);
            }
        }
        this.effect.getBundle().releaseLoader();
        return this.effectInstance != null;
    }

    @Override
    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        boolean redo = false;
        do {
            final AtomicBoolean result = new AtomicBoolean(false);
            this.effectInstance.showGui((JFrame)this.controller.getFrame(), new IGuiListener(){

                public void setPreviewing(boolean value) {
                }

                public void setByPass(boolean value) {
                }

                public void process() {
                    result.set(true);
                    EffectActionBase.this.effectInstance.hideGui();
                }

                public void cancel() {
                    result.set(false);
                    EffectActionBase.this.effectInstance.hideGui();
                }
            });
            boolean cont = result.get();
            if (!cont) {
                PlayStopAction.requestFocus();
                return false;
            }
            OverTime overTime = (OverTime)this.effectInstance.getAnnotation(OverTime.class);
            if (overTime == null) continue;
            Number value = 0;
            Object value0 = this.effectInstance.getParameterValue(overTime.parameterName());
            if (value0 instanceof Number) {
                value = (Number)value0;
            } else if (value0 instanceof Enum) {
                value = ((Enum)value0).ordinal();
            }
            if (value.doubleValue() >= overTime.minValue()) {
                redo = false;
                int choice = JOptionPane.showConfirmDialog(this.controller.getFrame(), OVERLUNCH_WARNING, "Confirm Overlunch Mode", 0, 2);
                if (choice == 0) continue;
                redo = true;
                continue;
            }
            redo = false;
        } while (redo);
        try {
            EffectPresets.storeEffectSessionDefaults(this.effect.getBundle(), this.effectInstance);
        }
        catch (Exception ex) {
            Debug.warn((String)"Failed to save the parameter values for effect {0}:\n{1}", (Object[])new Object[]{this.effect.getName(), ex});
        }
        PlayStopAction.requestFocus();
        return true;
    }

    @Override
    protected abstract boolean process(ActionEvent var1, IProgressMonitor var2) throws Exception;

    protected abstract boolean changesSelection();

    public int getNumberOfChannels() {
        if (this.curSelection == null) {
            return -1;
        }
        return this.curSelection.getChannels().cardinality();
    }

    public float getSampleRate() {
        if (this.currentFile == null) {
            return Float.NaN;
        }
        return this.currentFile.getSampleRate();
    }

    public int getQuantization() {
        return 24;
    }

    public final int getMaxChunkLength(int pluginOptimalChunkLength) {
        if (pluginOptimalChunkLength >= CacheSizes.getAudioProcessingMinBlockSize() && pluginOptimalChunkLength <= CacheSizes.getAudioProcessingMaxBlockSize()) {
            return pluginOptimalChunkLength;
        }
        return CacheSizes.getAudioProcessBlockSize();
    }

    public final int getHostPreferredChunkLength() {
        return CacheSizes.getAudioProcessBlockSize();
    }

    public final int negociateFixedChunkLength(int pluginOptimalChunkLength) {
        this.chunkLength = pluginOptimalChunkLength >= CacheSizes.getAudioProcessingMinBlockSize() && pluginOptimalChunkLength <= CacheSizes.getAudioProcessingMaxBlockSize() ? pluginOptimalChunkLength : CacheSizes.getAudioProcessBlockSize();
        return this.chunkLength;
    }

    protected final int getProcessingChunkLength() {
        if (this.chunkLength <= 0) {
            this.chunkLength = CacheSizes.getAudioProcessBlockSize();
        }
        return this.chunkLength;
    }

    public long getLength() {
        if (this.curSelection == null) {
            return -1L;
        }
        return this.curSelection.getBoundingStopPosition() - this.curSelection.getBoundingStartPosition();
    }

    protected final boolean processAllChansTogether(IProgressMonitor progress) throws IOException {
        SelectionProcessContext context = new SelectionProcessContext();
        Debug.info((String)"Applying effect {0}", (Object[])new Object[]{this.effect2string((IEffect)this.effectInstance)});
        progress.setText("Applying \"{0}\" to the selection...", this.effect.getName());
        AudioFile file = this.session.getCurrentFile();
        context.audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        context.total = sInfo.getLength();
        context.done = 0L;
        ArrayList<ISelection> processed = new ArrayList<ISelection>();
        context.processedStop = 0L;
        BitSet processedChanSet = new BitSet();
        Platform.lowerPriority();
        try {
            try {
                progress.reset();
                for (ISelection selection : sInfo.getSortedSelections()) {
                    if (!(selection instanceof TimeRangeSelection)) continue;
                    TimeRangeSelection trSel = (TimeRangeSelection)selection;
                    context.start = trSel.getStartPosition();
                    context.length = trSel.getStopPosition() - trSel.getStartPosition();
                    context.curChanSet = context.allChanSet = trSel.getChannels();
                    if (!context.curChanSet.isEmpty()) {
                        context.processedStop = context.start;
                        processedChanSet = context.curChanSet;
                        context.nbChannels = context.curChanSet.cardinality();
                        this.curSelection = trSel;
                        this.effectInstance.startProcessing((IProcessingInfo)this);
                        long additionalFrames = this.effectInstance.getAdditionalInputFrames();
                        try {
                            this.processSelectionAllChans(progress, context);
                        }
                        finally {
                            this.effectInstance.stopProcessing();
                        }
                        TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, context.start, context.processedStop, processedChanSet);
                        processed.add(curProcessed);
                        context.done += context.length + additionalFrames;
                    }
                    this.curSelection = null;
                }
                context.audio.commit();
                if (this.changesSelection()) {
                    file.getSelection().clear();
                    file.getSelection().addSelections(processed);
                }
                super.logActionSuccessful(file, this.effect.getName());
            }
            catch (OperationAbortedException ex) {
                if (ex.isCancel()) {
                    context.audio.rollback(progress);
                    super.logActionWarning(file, this.effect.getName(), "cancelled");
                } else {
                    context.audio.commit();
                    if (context.processedStop > context.start) {
                        TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, context.start, context.processedStop, processedChanSet);
                        processed.add(curProcessed);
                    }
                    file.getSelection().clear();
                    file.getSelection().addSelections(processed);
                    super.logActionWarning(file, this.effect.getName(), "stopped");
                }
                this.curSelection = null;
                this.effectInstance.unload();
                this.effectInstance = null;
                Platform.normalPriority();
                file.getSelection().cleanup();
                file.getView().ensureCoherent();
            }
        }
        finally {
            this.curSelection = null;
            this.effectInstance.unload();
            this.effectInstance = null;
            Platform.normalPriority();
            file.getSelection().cleanup();
            file.getView().ensureCoherent();
        }
        return false;
    }

    protected void processSelectionAllChans(IProgressMonitor progress, SelectionProcessContext context) throws IOException, OperationAbortedException {
        throw new AbstractMethodError();
    }

    protected boolean processChanByChan(IProgressMonitor progress) throws IOException {
        Debug.info((String)"Applying effect {0}", (Object[])new Object[]{this.effect2string((IEffect)this.effectInstance)});
        progress.setText("Applying \"{0}\" to the selection...", this.effect.getName());
        SelectionProcessContext context = new SelectionProcessContext();
        AudioFile file = this.session.getCurrentFile();
        context.audio = file.getData();
        SelectionInfo sInfo = file.getSelection();
        context.total = sInfo.getLength();
        context.done = 0L;
        ArrayList<ISelection> processed = new ArrayList<ISelection>();
        BitSet processedChanSet = new BitSet();
        Platform.lowerPriority();
        try {
            try {
                progress.reset();
                long cumulatedShift = 0L;
                for (ISelection selection : sInfo.getSortedSelections()) {
                    if (!(selection instanceof TimeRangeSelection)) continue;
                    TimeRangeSelection trSel = (TimeRangeSelection)selection;
                    context.start = trSel.getStartPosition() + cumulatedShift;
                    context.length = trSel.getStopPosition() - trSel.getStartPosition();
                    context.allChanSet = trSel.getChannels();
                    context.chanNum = 0;
                    int chan = context.allChanSet.nextSetBit(0);
                    while (chan >= 0) {
                        context.curChanSet = new BitSet();
                        context.curChanSet.set(chan);
                        context.nbChannels = 1;
                        context.processedStop = context.start;
                        processedChanSet.set(chan);
                        this.curSelection = trSel;
                        this.effectInstance.startProcessing((IProcessingInfo)this);
                        long additionalFrames = this.effectInstance.getAdditionalInputFrames();
                        try {
                            this.processSelectionOneChan(context, progress);
                        }
                        finally {
                            this.effectInstance.stopProcessing();
                        }
                        context.done += context.length + additionalFrames;
                        ++context.chanNum;
                        chan = context.allChanSet.nextSetBit(chan + 1);
                    }
                    TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, context.start, context.processedStop, processedChanSet);
                    processed.add(curProcessed);
                    this.curSelection = null;
                    cumulatedShift += context.processedStop - context.start - context.length;
                }
                context.audio.commit();
                if (this.changesSelection()) {
                    file.getSelection().clear();
                    file.getSelection().addSelections(processed);
                }
                super.logActionSuccessful(file, this.effect.getName());
            }
            catch (OperationAbortedException ex) {
                if (ex.isCancel()) {
                    context.audio.rollback(progress);
                    super.logActionWarning(file, this.effect.getName(), "cancelled");
                } else {
                    context.audio.commit();
                    if (context.processedStop > context.start) {
                        TimeRangeSelection curProcessed = new TimeRangeSelection(sInfo, context.start, context.processedStop, processedChanSet);
                        processed.add(curProcessed);
                    }
                    file.getSelection().clear();
                    file.getSelection().addSelections(processed);
                    super.logActionWarning(file, this.effect.getName(), "stopped");
                }
                this.curSelection = null;
                this.effectInstance.unload();
                this.effectInstance = null;
                Platform.normalPriority();
                file.getSelection().cleanup();
                file.getView().ensureCoherent();
            }
            catch (Exception ex) {
                Debug.error((Throwable)ex);
                context.audio.rollback(progress);
                this.curSelection = null;
                this.effectInstance.unload();
                this.effectInstance = null;
                Platform.normalPriority();
                file.getSelection().cleanup();
                file.getView().ensureCoherent();
            }
        }
        finally {
            this.curSelection = null;
            this.effectInstance.unload();
            this.effectInstance = null;
            Platform.normalPriority();
            file.getSelection().cleanup();
            file.getView().ensureCoherent();
        }
        return false;
    }

    protected void processSelectionOneChan(SelectionProcessContext context, IProgressMonitor progress) throws IOException, OperationAbortedException {
        throw new AbstractMethodError();
    }

    private String effect2string(IEffect effect) {
        StringBuilder result = new StringBuilder();
        result.append(effect.getName());
        result.append("[");
        boolean isFirst = true;
        for (IParameter param : effect.getParameters()) {
            if (!isFirst) {
                result.append(",");
            }
            isFirst = false;
            result.append(param.getDisplayName());
            result.append("=");
            result.append(param.getValue((IProcessingInfo)this));
        }
        result.append("]");
        return result.toString();
    }

    private class AudioChannelAdapter
    implements AudioChannelListener {
        private AudioChannelAdapter() {
        }

        public void dataModified(AudioChannel channel, long startPos, long stopPos) {
        }

        public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
            if (oldSize == 0L != (newSize == 0L)) {
                EffectActionBase.this.updateEnabledStatus();
            }
        }

        public void transactionStateChanged(AudioChannel channel, boolean running) {
        }
    }

    private class SelAdapter
    extends SelectionAdapter {
        private SelAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            if (!isAdjusting) {
                EffectActionBase.this.updateEnabledStatus();
            }
        }
    }
}

