/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.message.MessageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.corebounce.common.audio.file.AudioFiles;
import org.corebounce.common.gui.TableLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AskMultipleSaveDialog
extends JDialog {
    private final List<AudioFile> files;
    private final Set<AudioFile> toSave = new HashSet<AudioFile>();
    private final Map<AudioFile, String> saveTypes = new HashMap<AudioFile, String>();
    private final List<String> availableSaveFormats;
    private boolean userChoice = false;

    public AskMultipleSaveDialog(JFrame parent, List<AudioFile> files) {
        super((Frame)parent, true);
        this.setResizable(false);
        this.files = files;
        this.availableSaveFormats = this.getAvailableSaveFormats();
        this.setTitle("Quit");
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        this.setLayout(new FlowLayout(1, 8, 8));
        this.add(main);
        JLabel headLabel = new JLabel("<html><body><b>Some files are not saved.<p>Do you want to save them?</b></body></html>", this.getWarnIcon(), 10);
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new FlowLayout(0, 5, 10));
        headPanel.add(headLabel);
        main.add((Component)headPanel, "North");
        JPanel fileListPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        fileListPanel.setLayout(new TableLayout(2, gbc));
        JLabel hdFile = new JLabel("<html><body><b>File</b></body></html>");
        hdFile.setBorder(new BevelBorder(0));
        fileListPanel.add(hdFile);
        JLabel hdFormat = new JLabel("<html><body><b>Format</b></body></html>");
        hdFormat.setBorder(new BevelBorder(0));
        fileListPanel.add(hdFormat);
        for (final AudioFile file : files) {
            this.toSave.add(file);
            String fileName = file.getFile() == null ? "New Audio File" : file.getFile().getName();
            final JCheckBox chkSave = new JCheckBox(fileName, true);
            String tooltip = file.getFile() == null ? null : file.getFile().getAbsolutePath();
            chkSave.setToolTipText(tooltip);
            chkSave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AskMultipleSaveDialog.this.clickFile(file, chkSave.isSelected());
                }
            });
            fileListPanel.add(chkSave);
            final JComboBox<Object> cbFormat = new JComboBox<Object>(this.availableSaveFormats.toArray());
            cbFormat.setToolTipText("Format in which the file will be saved");
            if (file.isWritableFormat()) {
                cbFormat.setSelectedItem(file.getReadFormat());
            } else {
                String fileType = AudioFiles.instance().getAudioFileType(AudioFiles.instance().getPlatformDefaultType());
                cbFormat.setSelectedItem(fileType);
            }
            cbFormat.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AskMultipleSaveDialog.this.changeFileType(file, (String)cbFormat.getSelectedItem());
                }
            });
            fileListPanel.add(cbFormat);
        }
        JScrollPane scroller = new JScrollPane(fileListPanel, 20, 31);
        main.add((Component)scroller, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 2));
        main.add((Component)buttonsPanel, "South");
        JButton saveButton = new JButton("Save selected files");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AskMultipleSaveDialog.this.save();
            }
        });
        JPanel savePanel = new JPanel(new FlowLayout());
        savePanel.add(saveButton);
        buttonsPanel.add(savePanel);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AskMultipleSaveDialog.this.cancel();
            }
        });
        JPanel cancelPanel = new JPanel(new FlowLayout());
        cancelPanel.add(cancelButton);
        buttonsPanel.add(cancelPanel);
    }

    private Icon getWarnIcon() {
        Icon result = UIManager.getIcon("OptionPane.warningIcon");
        if (result != null) {
            return result;
        }
        return MessageType.WARNING.getIcon(-1);
    }

    private List<String> getAvailableSaveFormats() {
        return new ArrayList<String>(AudioFiles.instance().getSupportedWriteTypes());
    }

    private void clickFile(AudioFile file, boolean checked) {
        if (checked) {
            this.toSave.add(file);
        } else {
            this.toSave.remove(file);
        }
    }

    private void changeFileType(AudioFile file, String type) {
        this.saveTypes.put(file, type);
    }

    private void save() {
        this.userChoice = true;
        this.setVisible(false);
    }

    private void cancel() {
        this.userChoice = false;
        this.setVisible(false);
    }

    public boolean getUserChoice() {
        return this.userChoice;
    }

    public List<AudioFile> getFilesToSave() {
        ArrayList<AudioFile> result = new ArrayList<AudioFile>();
        for (AudioFile file : this.files) {
            if (!this.toSave.contains(file)) continue;
            String saveType = this.saveTypes.get(file);
            if (saveType != null) {
                file.setWriteFormat(AudioFiles.instance().getWritableType(saveType));
            }
            result.add(file);
        }
        return result;
    }
}

