/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.file.SaveAction;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.StringUtils;

public class CloseAction
extends ActionBase {
    public CloseAction() {
        super.setDetails("Close", 119, 67);
        super.setTooltip("Close the current file");
        this.setEnabled(false);
    }

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                CloseAction.this.currentFileChanged(audioFile);
            }
        });
    }

    private void currentFileChanged(AudioFile audioFile) {
        this.setEnabled(audioFile != null);
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioFile audioFile = this.session.getCurrentFile();
        if (audioFile == null) {
            return false;
        }
        if (audioFile.isModified()) {
            int choice = CloseAction.askForSaveOne(audioFile, this, this.controller);
            return choice == 1;
        }
        return true;
    }

    static int askForSaveOne(AudioFile audioFile, final ActionBase trigerAction, final Controller controller) {
        StringBuilder messageBuilder = new StringBuilder();
        if (audioFile.getFile() == null) {
            messageBuilder.append("The new file has not been saved.");
        } else {
            messageBuilder.append("File \"{0}\" was modified.");
        }
        messageBuilder.append("\nDou you want to save it?");
        final String message = StringUtils.format(messageBuilder.toString(), audioFile.getFile() == null ? null : audioFile.getFile().getName());
        final AtomicInteger userChoice = new AtomicInteger(2);
        AwtTools.invokeAndWait(new Runnable(){

            public void run() {
                int result = AwtTools.showYesNoCancelDialog(controller.getFrame(), message, trigerAction.getText(), "Save", "Don't Save", 0);
                userChoice.set(result);
                if (result == 2) {
                    return;
                }
                if (result == 0) {
                    SaveAction.getInstance().setQueueAction(trigerAction);
                    SaveAction.getInstance().actionPerformed(null);
                    SaveAction.getInstance().setQueueAction(null);
                    return;
                }
            }
        });
        return userChoice.get();
    }

    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        AudioFile audioFile = this.session.getCurrentFile();
        if (Transport.getInstance().getAudioFile() == audioFile) {
            Transport.getInstance().setPlayState(PlayState.STOP);
        }
        if (audioFile != null) {
            List<AudioFile> files = this.session.getFiles();
            int index = files.indexOf(audioFile);
            this.session.removeFile(audioFile);
            audioFile.dispose();
            if (!files.isEmpty()) {
                AudioFile playingFile = Transport.getInstance().getAudioFile();
                if (playingFile != null) {
                    this.session.setCurrentFile(playingFile);
                } else {
                    audioFile = files.get(Math.max(index - 1, 0));
                    this.session.setCurrentFile(audioFile);
                }
            }
        }
        return false;
    }
}

