/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.SwingPreCompiler;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.sonics.gui.message.MessageType;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.corebounce.common.audio.file.AudioFileFilter;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;
import org.corebounce.common.utils.StringUtils;

public class OpenAction
extends ActionBase
implements ILafListener {
    static final String CURRENT_DIRECTORY_KEY = "currentDirectory";
    static final Preferences prefs = Preferences.userNodeForPackage(OpenAction.class);
    static JFileChooser chooser;
    private File[] filesToOpen = null;

    public OpenAction() {
        super.setDetails("Open...", 111, 79);
        super.setTooltip("Open an existing audio file...");
        AwtTools.addPostLafListener(this);
    }

    public void setFilesToOpen(File[] files) {
        this.filesToOpen = files;
    }

    protected AudioFile getAudioFile() {
        return null;
    }

    protected synchronized boolean guiPreProcess(ActionEvent e) {
        File curDir;
        String currentDirectory;
        ClassLoaderUtils.ensureClassPath();
        if (this.filesToOpen != null) {
            return true;
        }
        if (chooser == null) {
            chooser = SwingPreCompiler.getFileChooser();
            if (chooser == null) {
                chooser = new JFileChooser();
                SwingPreCompiler.setFileChooser(chooser);
            }
            chooser.addChoosableFileFilter(AudioFileFilter.readInstance());
            for (AudioFileFilter filter : AudioFileFilter.individualInstances(false)) {
                chooser.addChoosableFileFilter(filter);
            }
            chooser.addChoosableFileFilter(new FileFilter(){

                public String getDescription() {
                    return "Playlist files (*.m3u, *.m3u8)";
                }

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String name = f.getName().toLowerCase();
                    return name.endsWith(".m3u") || name.endsWith(".m3u8");
                }
            });
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.setFileFilter(AudioFileFilter.readInstance());
            chooser.setMultiSelectionEnabled(true);
        }
        if ((currentDirectory = prefs.get(CURRENT_DIRECTORY_KEY, null)) != null && (curDir = new File(currentDirectory)).isDirectory()) {
            chooser.setCurrentDirectory(curDir);
        }
        int result = chooser.showOpenDialog(this.controller.getFrame());
        chooser.setPreferredSize(chooser.getSize());
        if (result != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        File curDir2 = file.getParentFile();
        if (curDir2 != null && curDir2.isDirectory()) {
            prefs.put(CURRENT_DIRECTORY_KEY, curDir2.getAbsolutePath());
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Debug.warn((Throwable)ex);
            }
        }
        return true;
    }

    protected synchronized boolean process(ActionEvent e, IProgressMonitor progress) {
        ClassLoaderUtils.ensureClassPath();
        progress.setAbortable(false, true);
        File[] files = this.filesToOpen != null ? this.filesToOpen : chooser.getSelectedFiles();
        this.filesToOpen = null;
        files = this.resolvePlaylists(files, progress);
        long total = 0L;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            total += file.length();
            ++n2;
        }
        int index = 1;
        long offset = 0L;
        File[] fileArray2 = files;
        int n3 = files.length;
        int n4 = 0;
        while (n4 < n3) {
            File file = fileArray2[n4];
            if (file.isFile()) {
                if (files.length > 1) {
                    progress.setStep(index, files.length);
                }
                AudioFile audioFile = new AudioFile(file);
                try {
                    audioFile.loadContent(progress, offset, total);
                    Session session = this.controller.getSession();
                    boolean setCurrent = session.getFiles().isEmpty();
                    session.addFile(audioFile);
                    if (setCurrent) {
                        session.setCurrentFile(audioFile);
                    }
                    Message.info("File \"{0}\" opened", file.getName());
                }
                catch (IOException ex) {
                    Debug.error((Throwable)ex);
                }
                catch (UnsupportedAudioFileException ex) {
                    String text = StringUtils.format("Unable to open file {0}", file.getName());
                    Message message = new Message(MessageType.ERROR, text, "Unsupported audio file format");
                    message.publish();
                }
                catch (OperationAbortedException ex) {
                    audioFile.dispose();
                    Message.message(MessageType.WARNING, "Open file aborted");
                    return false;
                }
            } else {
                Message.error("File not found: {0}", file.getPath());
            }
            ++index;
            offset += file.length();
            ++n4;
        }
        return true;
    }

    private File[] resolvePlaylists(File[] files, IProgressMonitor progress) {
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                File file = fileArray[n2];
                if (file.getName().endsWith(".m3u") || file.getName().endsWith(".m3u8")) {
                    progress.setText("Scanning playlist \"{0}\"", file.getName());
                    File parent = file.getParentFile();
                    BufferedReader reader = null;
                    try {
                        try {
                            FileInputStream stream = new FileInputStream(file);
                            InputStreamReader reader0 = file.getName().endsWith(".m3u8") ? new InputStreamReader((InputStream)stream, Charset.forName("UTF-8")) : new InputStreamReader((InputStream)stream, Charset.forName("ISO-8859-1"));
                            reader = new BufferedReader(reader0);
                            String line = reader.readLine();
                            while (line != null) {
                                if (StringUtils.isNotBlank(line) && !line.startsWith("#")) {
                                    File item;
                                    int commentPos = line.indexOf(35);
                                    if (commentPos < 0) {
                                        commentPos = line.length();
                                    }
                                    if (!(item = new File(line.substring(0, commentPos))).isAbsolute()) {
                                        item = new File(parent, item.getPath());
                                    }
                                    if (item.exists() && item.isFile()) {
                                        result.add(item);
                                    }
                                }
                                line = reader.readLine();
                            }
                        }
                        catch (IOException ex) {
                            Debug.error((Throwable)ex);
                            IOUtils.close(reader);
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(reader);
                        throw throwable;
                    }
                    IOUtils.close(reader);
                } else {
                    result.add(file);
                }
            }
            ++n2;
        }
        return result.toArray(new File[result.size()]);
    }

    public void lookAndFeelChanged(String lafClassName) {
        OpenAction.clearChooser();
        SwingPreCompiler.setFileChooser(null);
    }

    public static void clearChooser() {
        chooser = null;
    }
}

