/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.ActionPool;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.file.CloseAction;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.utils.IProgressMonitor;

public class QuitAction
extends ActionBase {
    private transient AudioFile fileToClose = null;

    public QuitAction() {
        super.setDetails("Quit", 113, 81);
        super.setTooltip("Quit the application");
    }

    protected boolean guiPreProcess(ActionEvent e) {
        return true;
    }

    public boolean process(ActionEvent e, IProgressMonitor progress) {
        ActionPool.waitForAllActions(this, true);
        Transport.getInstance().setPlayState(PlayState.STOP);
        ArrayList<AudioFile> unsavedFiles = new ArrayList<AudioFile>();
        for (AudioFile file : new ArrayList<AudioFile>(this.session.getFiles())) {
            if (!file.isModified()) continue;
            unsavedFiles.add(file);
        }
        if (!unsavedFiles.isEmpty()) {
            for (AudioFile file : new ArrayList<AudioFile>(this.session.getFiles())) {
                if (file.isModified()) continue;
                if (file == this.fileToClose) {
                    this.fileToClose = null;
                    this.session.removeFile(file);
                    AwtTools.flushEDT();
                    file.dispose();
                    continue;
                }
                if (!unsavedFiles.isEmpty()) continue;
                this.session.removeFile(file);
                AwtTools.flushEDT();
                file.dispose();
            }
            while (!unsavedFiles.isEmpty()) {
                AudioFile victim = (AudioFile)unsavedFiles.get(0);
                this.session.setCurrentFile(victim);
                int choice = CloseAction.askForSaveOne(victim, this, this.controller);
                if (choice == 2) {
                    return false;
                }
                if (choice == 0) {
                    this.fileToClose = victim;
                    return false;
                }
                this.session.removeFile(victim);
                AwtTools.flushEDT();
                victim.dispose();
                unsavedFiles.remove(victim);
            }
        }
        ActionPool.setAllEnabled(false);
        this.controller.quit();
        new Thread(){

            public void run() {
                ActionBase.cleanup();
            }
        }.start();
        return false;
    }

    public static void quit() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MenuBar.getInstance().getFileMenu().getQuitAction().actionPerformed(null);
            }
        });
    }
}

