/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.edit.HistoryActionBase;
import ch.tachyon.sonics.action.file.SaveAsAction;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.StringUtils;

public class SaveAction
extends HistoryActionBase {
    private ActionBase queueAction;

    public SaveAction(Controller controller) {
        super(controller);
        super.setDetails("Save", 115, 83);
        super.setTooltip("Save all changes done the current file");
        this.setEnabled(false);
    }

    static SaveAction getInstance() {
        return MenuBar.getInstance().getFileMenu().getSaveAction();
    }

    void setQueueAction(ActionBase queueAction) {
        this.queueAction = queueAction;
    }

    protected boolean getEnabled(AudioFile file) {
        return file != null && file.isModified();
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        boolean modified = false;
        for (AudioFile file : this.session.getFiles()) {
            if (!file.isModified()) continue;
            modified = true;
            break;
        }
        if (this.controller.getFrame() != null) {
            this.controller.getFrame().setModifiedStatus(this.getAudioFile(), modified);
        }
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        ClassLoaderUtils.ensureClassPath();
        AudioFile currentFile = super.getAudioFile();
        if (currentFile == null || !currentFile.isModified()) {
            return false;
        }
        if (currentFile.getFile() == null) {
            SaveAsAction.getInstance().setQueueAction(this.queueAction);
            SaveAsAction.getInstance().actionPerformed(e);
            SaveAsAction.getInstance().setQueueAction(null);
            return false;
        }
        if (!currentFile.isWritableFormat()) {
            JOptionPane.showMessageDialog(this.controller.getFrame(), StringUtils.format("File \"{0}\" is in {1} format.\nSaving in {1} format is not supported.\nPlease choose another format.", currentFile.getFile().getName(), currentFile.getReadFormat()), "Save", 1);
            SaveAsAction.getInstance().setQueueAction(this.queueAction);
            SaveAsAction.getInstance().actionPerformed(e);
            SaveAsAction.getInstance().setQueueAction(null);
            return false;
        }
        return true;
    }

    protected void process(AudioFile currentFile, IProgressMonitor progress) {
        ClassLoaderUtils.ensureClassPath();
        progress.setAbortable(false, true);
        try {
            currentFile.saveContent(progress);
            currentFile.savePoint();
            Message.info("File \"{0}\" saved", currentFile.getFile().getName());
            if (this.queueAction != null) {
                final ActionBase todo = this.queueAction;
                this.queueAction = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        todo.actionPerformed(null);
                    }
                });
            }
        }
        catch (InterruptedException todo) {
        }
        catch (IllegalArgumentException ex) {
            Debug.error((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            Debug.error((Throwable)ex);
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
    }
}

