/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.file;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.file.OpenAction;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.gui.message.Message;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.corebounce.common.audio.file.AudioFileFilter;
import org.corebounce.common.audio.file.AudioFiles;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.utils.ClassLoaderUtils;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;

public class SaveAsAction
extends ActionBase
implements ILafListener {
    private static final String CURRENT_DIRECTORY_KEY = "currentDirectory";
    private static final Preferences prefs = OpenAction.prefs;
    private static JFileChooser chooser;
    private static File curChooserFile;
    private ActionBase queueAction;
    private AudioFile currentFile = null;

    public SaveAsAction() {
        super.setDetails("Save As...", 83, 65);
        super.setTooltip("Save the current file under a different name...");
        this.setEnabled(false);
        AwtTools.addPostLafListener(this);
    }

    static SaveAsAction getInstance() {
        return MenuBar.getInstance().getFileMenu().getSaveAsAction();
    }

    void setQueueAction(ActionBase queueAction) {
        this.queueAction = queueAction;
    }

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                SaveAsAction.this.currentFileChanged(audioFile);
            }
        });
    }

    private void currentFileChanged(AudioFile audioFile) {
        this.currentFile = audioFile;
        this.setEnabled(audioFile != null);
    }

    protected synchronized boolean guiPreProcess(ActionEvent e) {
        File curDir;
        File file;
        int n;
        ClassLoaderUtils.ensureClassPath();
        if (chooser == null) {
            chooser = new JFileChooser();
            for (AudioFileFilter filter : AudioFileFilter.individualInstances(true)) {
                chooser.addChoosableFileFilter(filter);
            }
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setMultiSelectionEnabled(false);
            chooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    File curFile = chooser.getSelectedFile();
                    if (curFile != null) {
                        curChooserFile = curFile;
                    }
                }
            });
            chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() instanceof AudioFileFilter) {
                        if (curChooserFile == null) {
                            return;
                        }
                        String fileName = curChooserFile.getPath();
                        if (fileName == null) {
                            return;
                        }
                        int lastDot = fileName.lastIndexOf(46);
                        if (lastDot < 0) {
                            return;
                        }
                        AudioFileFilter newFilter = (AudioFileFilter)evt.getNewValue();
                        if (newFilter.getMainExtension() == null) {
                            return;
                        }
                        fileName = String.valueOf(fileName.substring(0, lastDot)) + newFilter.getMainExtension();
                        chooser.setSelectedFile(new File(fileName));
                    }
                }
            });
        }
        if (this.currentFile != null && this.currentFile.getFile() != null) {
            int lastDot;
            File curDir2 = this.currentFile.getFile().getAbsoluteFile().getParentFile();
            chooser.setCurrentDirectory(curDir2);
            if (this.currentFile.isWritableFormat()) {
                chooser.setSelectedFile(this.currentFile.getFile());
            } else {
                String fileName = this.currentFile.getFile().getAbsolutePath();
                lastDot = fileName.lastIndexOf(46);
                if (lastDot >= 0) {
                    fileName = fileName.substring(0, lastDot);
                }
                fileName = String.valueOf(fileName) + "." + AudioFiles.instance().getPlatformDefaultType().getExtension();
                chooser.setSelectedFile(new File(fileName));
            }
            FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            n = fileFilterArray.length;
            lastDot = 0;
            while (lastDot < n) {
                FileFilter ff = fileFilterArray[lastDot];
                if (ff.accept(this.currentFile.getFile())) {
                    chooser.setFileFilter(ff);
                    break;
                }
                ++lastDot;
            }
        } else {
            File curDir3;
            String currentDirectory = prefs.get(CURRENT_DIRECTORY_KEY, null);
            if (currentDirectory != null && (curDir3 = new File(currentDirectory)).isDirectory()) {
                chooser.setCurrentDirectory(curDir3);
            }
            File dummy = new File("toto." + AudioFiles.instance().getPlatformDefaultType().getExtension());
            FileFilter[] fileFilterArray = chooser.getChoosableFileFilters();
            int n2 = fileFilterArray.length;
            n = 0;
            while (n < n2) {
                FileFilter ff = fileFilterArray[n];
                if (ff.accept(dummy)) {
                    chooser.setFileFilter(ff);
                    break;
                }
                ++n;
            }
        }
        boolean redo = false;
        do {
            int result = chooser.showSaveDialog(this.controller.getFrame());
            chooser.setPreferredSize(chooser.getSize());
            if (result != 0) {
                return false;
            }
            file = chooser.getSelectedFile();
            redo = false;
            if (!file.exists()) continue;
            result = AwtTools.showYesNoCancelDialog(this.controller.getFrame(), String.valueOf(file.getName()) + " already exists.\nDo you want to replace it?", "Confirm Replace", "Replace", "Don't replace", 1);
            if (result == 0) break;
            if (result == 2) {
                return false;
            }
            redo = true;
        } while (redo);
        if ((curDir = file.getAbsoluteFile().getParentFile()) != null && curDir.isDirectory()) {
            prefs.put(CURRENT_DIRECTORY_KEY, curDir.getAbsolutePath());
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Debug.warn((Throwable)ex);
            }
        }
        return true;
    }

    protected synchronized boolean process(ActionEvent e, IProgressMonitor progress) {
        ClassLoaderUtils.ensureClassPath();
        File file = chooser.getSelectedFile();
        String fileName = file.getAbsolutePath();
        AudioFileFormat.Type writeType = AudioFiles.instance().getWritableType4ext(fileName);
        if (writeType == null) {
            int lastDot = fileName.lastIndexOf(46);
            if (lastDot >= 0) {
                String extension = fileName.substring(lastDot);
                Debug.error((String)"Unsupported file format: ", (Object[])new Object[]{extension});
            } else {
                String extension = null;
                FileFilter curFilter = chooser.getFileFilter();
                if (curFilter instanceof AudioFileFilter) {
                    AudioFileFilter aff = (AudioFileFilter)curFilter;
                    extension = aff.getMainExtension();
                }
                if (extension != null) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + extension);
                    fileName = file.getAbsolutePath();
                    writeType = AudioFiles.instance().getWritableType4ext(fileName);
                } else {
                    PlatformType platform = Platform.getPlatform();
                    if (platform.equals((Object)PlatformType.MACOSX)) {
                        writeType = AudioFileFormat.Type.AIFC;
                    } else if (platform.equals((Object)PlatformType.WINDOWS)) {
                        file = new File(String.valueOf(file.getAbsolutePath()) + ".wav");
                        writeType = AudioFileFormat.Type.WAVE;
                    } else {
                        file = new File(String.valueOf(file.getAbsolutePath()) + ".au");
                        writeType = AudioFileFormat.Type.AU;
                    }
                }
            }
        }
        this.currentFile.setFile(file);
        this.currentFile.setWriteFormat(writeType);
        try {
            this.currentFile.saveContent(progress);
            this.currentFile.savePoint();
            Message.info("File \"{0}\" saved", this.currentFile.getFile().getName());
            OpenAction.clearChooser();
            if (this.queueAction != null) {
                final ActionBase todo = this.queueAction;
                this.queueAction = null;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        todo.actionPerformed(null);
                    }
                });
            }
        }
        catch (InterruptedException todo) {
        }
        catch (IllegalArgumentException ex) {
            Debug.error((Throwable)ex);
        }
        catch (IllegalStateException ex) {
            Debug.error((Throwable)ex);
        }
        catch (IOException ex) {
            Debug.error((Throwable)ex);
        }
        return true;
    }

    public void lookAndFeelChanged(String lafClassName) {
        chooser = null;
    }
}

