/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.help;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.TachyonSonics;
import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.file.QuitAction;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionListener;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.io.Base64;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.IProgressMonitor;
import org.corebounce.common.utils.OperationAbortedException;

public class CheckForUpdatesAction
extends ActionBase
implements SessionListener {
    private static final String HASH_URL = "http://www.tachyon-sonics.com/updates/installer.sha1";
    private static final String JAR_URL = "http://www.tachyon-sonics.com/updates/installer.jar";

    public CheckForUpdatesAction(Controller controller) {
        super.setDetails("Check for Updates", 85);
        this.setController(controller);
    }

    protected void init() {
        this.session.addSessionListener(this);
        this.updateEnabledStatus();
    }

    public void fileAdded(Session session, AudioFile audioFile) {
        this.updateEnabledStatus();
    }

    public void fileRemoved(Session session, AudioFile audioFile) {
        this.updateEnabledStatus();
    }

    public void currentFileChanged(Session session, AudioFile audioFile) {
    }

    public void focusedFileChanged(Session session, AudioFile audioFile) {
    }

    private void updateEnabledStatus() {
        this.setEnabled(this.session.getFiles().isEmpty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process(ActionEvent e, IProgressMonitor progress) throws Exception {
        try {
            byte[] hash;
            URL shaUrl = new URL(HASH_URL);
            InputStream stream = shaUrl.openStream();
            InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
            char[] hashB64 = new char[28];
            int offset = 0;
            while (true) {
                if (offset >= 28) {
                    IOUtils.close(reader);
                    hash = Base64.decode(new String(hashB64));
                    final AtomicInteger result = new AtomicInteger(1);
                    AwtTools.invokeAndWait(new Runnable(){

                        public void run() {
                            int userChoice = JOptionPane.showConfirmDialog(CheckForUpdatesAction.this.controller.getFrame(), "A new version is available.\nWould you like to download and install it?", "Check for Updates", 0, 3);
                            result.set(userChoice);
                        }
                    });
                    if (result.get() == 0) break;
                    return false;
                }
                int read = ((Reader)reader).read(hashB64, offset, 28 - offset);
                if (read < 0) {
                    return false;
                }
                offset += read;
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            URL jarUrl = new URL(JAR_URL);
            stream = jarUrl.openStream();
            File jarFile = File.createTempFile("Installer", ".jar");
            FileOutputStream output = new FileOutputStream(jarFile);
            long total = 0L;
            byte[] buffer = new byte[8192];
            int read = stream.read(buffer);
            while (true) {
                if (read <= 0) {
                    IOUtils.close(output);
                    IOUtils.close(stream);
                    byte[] computedHash = digest.digest();
                    if (Arrays.equals(hash, computedHash)) break;
                    Debug.error((String)"An installer was found, but it is corrupted", (Object[])new Object[0]);
                    return false;
                }
                digest.update(buffer, 0, read);
                ((OutputStream)output).write(buffer, 0, read);
                progress.setText("Downloading installer ({0})", CheckForUpdatesAction.formatSize(total += (long)read));
                progress.setProgress(Double.NaN, 0.0);
                read = stream.read(buffer);
            }
            if (!this.session.getFiles().isEmpty()) {
                Debug.error((String)"You must close all files to perform an update", (Object[])new Object[0]);
                return false;
            }
            String javaHome = System.getProperty("java.home");
            String javaCmd = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
            ArrayList<String> command = new ArrayList<String>(Arrays.asList(javaCmd, "-jar", jarFile.getAbsolutePath(), AppUtils.getApplicationDirectory(TachyonSonics.class).getAbsolutePath()));
            Debug.warn((String)"Executing: {0}", (Object[])new Object[]{command});
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
            return true;
        }
        catch (OperationAbortedException ex) {
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    protected void guiPostProcess(ActionEvent e) throws Exception {
        QuitAction.quit();
    }

    private static String formatSize(double value) {
        String[] suffixes = new String[]{"B", "KB", "MB", "GB", "TB"};
        int suffixIndex = 0;
        while (value >= 1300.0 && suffixIndex < suffixes.length - 1) {
            value /= 1024.0;
            ++suffixIndex;
        }
        DecimalFormat format = new DecimalFormat("#0.##");
        return format.format(value) + " " + suffixes[suffixIndex];
    }

    public static void main(String[] args) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        URL jarUrl = new URL(JAR_URL);
        InputStream stream = jarUrl.openStream();
        byte[] buffer = new byte[8192];
        int read = stream.read(buffer);
        while (read > 0) {
            digest.update(buffer, 0, read);
            read = stream.read(buffer);
        }
        IOUtils.close(stream);
        byte[] computedHash = digest.digest();
        String hashString = Base64.encode(computedHash);
        System.out.println(hashString);
    }
}

