/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;

public class LoopAction
extends TransportActionBase {
    public LoopAction() {
        super.setDetails("Loop", 108, 76);
        this.setEnabled(false);
        this.setSelected(false);
    }

    protected void init() {
        Transport.getInstance().addTransportAdapter(new TransportAdapter(){

            public void loopModeChanged(Transport transport, boolean looping) {
                LoopAction.this.refreshState();
            }
        });
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                LoopAction.this.refreshState();
            }
        });
    }

    protected int getIconSize() {
        return 20;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.setSelected(false);
            Transport transport = Transport.getInstance();
            transport.setLooping(false);
        }
        super.setEnabled(enabled);
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        boolean checked = super.isSelected();
        Transport transport = Transport.getInstance();
        transport.setLooping(checked);
        this.refreshState();
        return false;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.CHECKBOX;
    }

    private void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null);
        this.setSelected(Transport.getInstance().isLooping());
    }
}

