/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.KeyStroke;
import org.corebounce.common.audio.device.AudioException;

public class PauseAction
extends TransportActionBase {
    public PauseAction() {
        super.setText("Pause");
        super.setMnemonic(65);
        super.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        super.addKeyboardShortcut(19);
        super.setEnabled(false);
        super.setSelected(false);
    }

    protected void init() {
        Transport.getInstance().addTransportAdapter(new TransportAdapter(){

            public void playStateChanged(Transport transport, PlayState oldPlayState, PlayState newPlayState) {
                PauseAction.this.refreshState();
            }
        });
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                PauseAction.this.refreshState();
            }
        });
    }

    protected int getIconSize() {
        return 20;
    }

    protected boolean guiPreProcess(ActionEvent e) throws AudioException, IOException {
        AudioFile file = this.session.getCurrentFile();
        if (file == null) {
            return false;
        }
        Transport transport = Transport.getInstance();
        if (transport.getPlayState() == PlayState.PAUSE) {
            transport.setPlayState(PlayState.PLAY);
        } else if (transport.getPlayState() == PlayState.PLAY) {
            transport.setPlayState(PlayState.PAUSE);
        } else {
            transport.setAudioFile(file);
            transport.initRangeAndLoop();
            transport.setPlayState(PlayState.PAUSE);
        }
        return false;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.TOGGLE;
    }

    private void refreshState() {
        PlayState playState = Transport.getInstance().getPlayState();
        AudioFile currentFile = this.session.getCurrentFile();
        boolean enabled = currentFile != null && currentFile.getLength() > 0L && playState != PlayState.STOP;
        boolean selected = playState == PlayState.PAUSE;
        this.setEnabled(enabled);
        this.setSelected(selected);
    }
}

