/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.corebounce.common.audio.device.AudioException;
import org.corebounce.common.gui.AwtTools;

public class PlayAction
extends TransportActionBase {
    private AudioFile lastFile = null;

    public PlayAction() {
        super.setText("Play");
        super.setMnemonic(80);
        super.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        super.setEnabled(false);
    }

    static PlayAction getInstance() {
        return MenuBar.getInstance().getTransportMenu().getPlayAction();
    }

    void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlayAction.this.getToolbarButton().requestFocusInWindow();
            }
        });
    }

    protected void init() {
        Transport.getInstance().addTransportAdapter(new TransportAdapter(){

            public void playStateChanged(Transport transport, PlayState oldPlayState, PlayState newPlayState) {
                PlayAction.this.refreshState();
                if (newPlayState == PlayState.STOP) {
                    PlayAction.this.requestFocus();
                }
            }
        });
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                PlayAction.this.refreshState();
                if (PlayAction.this.lastFile == null && audioFile != null) {
                    PlayAction.this.requestFocus();
                }
                PlayAction.this.lastFile = audioFile;
            }
        });
    }

    protected int getIconSize() {
        return 20;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.TOGGLE;
    }

    protected boolean guiPreProcess(ActionEvent e) throws AudioException, IOException {
        AudioFile file = this.session.getCurrentFile();
        if (file == null) {
            return false;
        }
        if (file.getLength() <= 0L) {
            return false;
        }
        Transport transport = Transport.getInstance();
        transport.setAudioFile(file);
        transport.initRangeAndLoop();
        if (transport.getPlayState() != PlayState.PLAY) {
            transport.setPlayState(PlayState.PLAY);
        } else {
            long newPos = file.getSelection().getCursorPosition();
            transport.seek(newPos);
            this.refreshState();
        }
        return false;
    }

    private void playPause(ActionEvent e) {
        AudioFile file = this.session.getCurrentFile();
        if (file == null) {
            return;
        }
        if (file.getLength() <= 0L) {
            return;
        }
        Transport transport = Transport.getInstance();
        transport.setAudioFile(file);
        transport.initRangeAndLoop();
        if (transport.getPlayState() == PlayState.PLAY) {
            transport.setPlayState(PlayState.PAUSE);
        } else {
            transport.setPlayState(PlayState.PLAY);
        }
    }

    private void playStop(ActionEvent e) {
        AudioFile file = this.session.getCurrentFile();
        if (file == null) {
            return;
        }
        if (file.getLength() <= 0L) {
            return;
        }
        Transport transport = Transport.getInstance();
        transport.setAudioFile(file);
        transport.initRangeAndLoop();
        if (transport.getPlayState() == PlayState.PLAY) {
            transport.setPlayState(PlayState.STOP);
        } else {
            transport.setPlayState(PlayState.PLAY);
        }
    }

    private void refreshState() {
        PlayState playState = Transport.getInstance().getPlayState();
        AudioFile currentFile = this.session.getCurrentFile();
        boolean enabled = currentFile != null;
        this.setEnabled(enabled);
        boolean selected = playState != PlayState.STOP;
        this.setSelected(selected);
    }

    protected void buttonCreated(AbstractButton button) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke('p');
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PlayAction.this.playPause(e);
            }
        }));
        keyStroke = KeyStroke.getKeyStroke(10, 0);
        actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PlayAction.this.playStop(e);
            }
        }));
    }
}

