/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import java.awt.event.ActionEvent;

public class PlaySelectionAction
extends TransportActionBase {
    private final SelectionAdapter selAdapter = new SelAdapter();
    private AudioFile currentFile;

    public PlaySelectionAction() {
        super.setDetails("Play Selection Only", 107, 79);
        super.setTooltip("Limit playback to the selected audio");
        this.setEnabled(false);
        this.setSelected(false);
    }

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                if (PlaySelectionAction.this.currentFile != null) {
                    PlaySelectionAction.this.currentFile.getSelection().removeSelectionListener(PlaySelectionAction.this.selAdapter);
                }
                PlaySelectionAction.this.currentFile = audioFile;
                if (PlaySelectionAction.this.currentFile != null) {
                    PlaySelectionAction.this.currentFile.getSelection().addSelectionListener(PlaySelectionAction.this.selAdapter);
                }
                PlaySelectionAction.this.refreshState();
            }
        });
    }

    protected int getIconSize() {
        return 20;
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.setSelected(false);
            Transport transport = Transport.getInstance();
            transport.setSelectionOnly(false);
            transport.initRangeAndLoop();
        }
        super.setEnabled(enabled);
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        boolean checked = super.isSelected();
        Transport transport = Transport.getInstance();
        transport.setSelectionOnly(checked);
        transport.initRangeAndLoop();
        if (checked) {
            SelectionInfo info = this.currentFile.getSelection();
            long cursor = info.getCursorPosition();
            long selStart = info.getBoundingStartPosition();
            long selStop = info.getBoundingStopPosition();
            if (cursor < selStart || cursor >= selStop) {
                info.setCursorPosition(selStart);
            }
        }
        return false;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.CHECKBOX;
    }

    private void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null && !currentFile.getSelection().isEmpty());
        this.setSelected(Transport.getInstance().isSelectionOnly());
    }

    private void autoRefreshSelected() {
        SelectionInfo info;
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null && !currentFile.getSelection().isEmpty());
        Boolean selected = false;
        if (currentFile != null && !(info = currentFile.getSelection()).isEmpty()) {
            long cursorPosition = info.getCursorPosition();
            for (ISelection selection : info.getSelections()) {
                long selStart = selection.getBoundingStartPosition();
                long selStop = selection.getBoundingStopPosition();
                if (cursorPosition == selStart) {
                    selected = true;
                    continue;
                }
                if (cursorPosition < selStart || cursorPosition >= selStop) continue;
                selected = null;
            }
        }
        if (selected == null) {
            return;
        }
        Transport transport = Transport.getInstance();
        if (selected.booleanValue() != this.isSelected() && !transport.getPlayState().equals((Object)PlayState.PLAY)) {
            this.setSelected(selected);
            Transport.getInstance().setSelectionOnly(selected);
            Transport.getInstance().initRangeAndLoop();
        }
    }

    private class SelAdapter
    extends SelectionAdapter {
        private SelAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            if (!isAdjusting) {
                PlaySelectionAction.this.autoRefreshSelected();
            }
        }

        public void cursorPositionChanged(SelectionInfo selectionInfo) {
            PlaySelectionAction.this.autoRefreshSelected();
        }
    }
}

