/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioFile;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ScrollingAction
extends TransportActionBase {
    public ScrollingAction() {
        super.setDetails("Scroll Display", 83);
        super.setAccelerator(KeyStroke.getKeyStroke(48, 0));
        super.addKeyboardShortcut(145);
        super.setTooltip("Smoothly scroll the audio display while playing to follow playback cursor");
        this.setEnabled(false);
        this.setSelected(false);
    }

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                ScrollingAction.this.refreshState();
            }
        });
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        boolean checked = super.isSelected();
        Transport transport = Transport.getInstance();
        transport.setScrolling(checked);
        this.refreshState();
        return false;
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.CHECKBOX;
    }

    private void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null);
        this.setSelected(Transport.getInstance().isScrolling());
    }
}

