/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.SessionAdapter;
import ch.tachyon.sonics.data.audio.AudioChannel;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.PlaybackListener;
import ch.tachyon.sonics.data.selection.SelectionAdapter;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.AudioFileViewListener;

public abstract class SeekActionBase
extends TransportActionBase
implements AudioFileViewListener {
    private AudioFile currentFile;
    private final StateAdapter selAdapter = new StateAdapter();
    private final TransportAdapter playbackAdapter = new PlaybackAdapter();
    private boolean playbackZero = true;
    private boolean playbackVisible = false;

    protected void init() {
        this.session.addSessionListener(new SessionAdapter(){

            public void currentFileChanged(Session session, AudioFile audioFile) {
                SeekActionBase.this.currentFileChanged(audioFile);
            }
        });
    }

    private void currentFileChanged(AudioFile newFile) {
        if (this.currentFile != null) {
            this.currentFile.getView().removeViewListener(this);
            this.currentFile.getSelection().removePlaybackListener(this.selAdapter);
            this.currentFile.getSelection().removeSelectionListener(this.selAdapter);
            Transport.getInstance().removeTransportAdapter(this.playbackAdapter);
        }
        this.currentFile = newFile;
        if (this.currentFile != null) {
            this.currentFile.getSelection().addSelectionListener(this.selAdapter);
            this.currentFile.getSelection().addPlaybackListener(this.selAdapter);
            this.currentFile.getView().addViewListener(this);
            Transport.getInstance().addTransportAdapter(this.playbackAdapter);
        }
        this.refreshState();
    }

    protected long getCursorPosition() {
        if (this.currentFile == null) {
            return -1L;
        }
        if (Transport.getInstance().getPlayState() == PlayState.STOP) {
            return this.currentFile.getSelection().getCursorPosition();
        }
        return this.currentFile.getSelection().getPlaybackPosition();
    }

    protected abstract void refreshState();

    public void viewChanged(AudioDataView view) {
        this.refreshState();
    }

    public void channelSizeChanged(AudioChannel channel, long oldSize, long newSize) {
        this.refreshState();
    }

    private class PlaybackAdapter
    extends TransportAdapter {
        private PlaybackAdapter() {
        }

        public void playStateChanged(Transport transport, PlayState oldPlayState, PlayState newPlayState) {
            SeekActionBase.this.refreshState();
        }
    }

    private class StateAdapter
    extends SelectionAdapter
    implements PlaybackListener {
        private StateAdapter() {
        }

        public void selectionChanged(SelectionInfo selectionInfo, ISelection oldSelection, ISelection newSelection, boolean isAdjusting) {
            SeekActionBase.this.refreshState();
        }

        public void cursorPositionChanged(SelectionInfo selectionInfo) {
            SeekActionBase.this.refreshState();
        }

        public void playbackPositionChanged(SelectionInfo selectionInfo) {
            boolean pv;
            long pos = SeekActionBase.this.getCursorPosition();
            long viewStart = SeekActionBase.this.currentFile.getView().getStartPosition();
            long viewStop = SeekActionBase.this.currentFile.getView().getStopPosition();
            boolean pz = pos <= 0L;
            boolean bl = pv = pos >= viewStart && pos <= viewStop;
            if (SeekActionBase.this.playbackZero != pz || SeekActionBase.this.playbackVisible != pv) {
                SeekActionBase.this.playbackZero = pz;
                SeekActionBase.this.playbackVisible = pv;
                SeekActionBase.this.refreshState();
            }
        }
    }
}

