/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.transport.SeekActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class SeekBackwardAction
extends SeekActionBase {
    public SeekBackwardAction() {
        super.setDetails("Seek Backward", 66);
        super.setTooltip("Seek backward to the previous selection or view boundary");
        super.setAccelerator(KeyStroke.getKeyStroke(115, 0));
        this.setEnabled(false);
    }

    protected int getIconSize() {
        return 20;
    }

    protected void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null && this.getCursorPosition() > currentFile.getView().getStartPosition());
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioFile currentFile = this.session.getCurrentFile();
        SelectionInfo info = currentFile.getSelection();
        long curPos = this.getCursorPosition();
        if (Transport.getInstance().getPlayState() == PlayState.PLAY) {
            int amount = (int)(currentFile.getSampleRate() / 2.0f);
            curPos = Math.max(curPos - (long)amount, 0L);
        }
        long newPos = currentFile.getView().getStartPosition();
        long viewStop = currentFile.getView().getStopPosition();
        if (viewStop < curPos) {
            newPos = Math.max(newPos, viewStop);
        }
        for (ISelection selection : info.getSelections()) {
            long selStop;
            long selStart = selection.getBoundingStartPosition();
            if (selStart < curPos && selStart < viewStop) {
                newPos = Math.max(newPos, selStart);
            }
            if ((selStop = selection.getBoundingStopPosition()) >= curPos || selStop >= viewStop) continue;
            newPos = Math.max(newPos, selStop);
        }
        info.setCursorPosition(newPos);
        Transport.getInstance().seek(newPos);
        return false;
    }
}

