/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.transport.SeekActionBase;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class SeekForwardAction
extends SeekActionBase {
    public SeekForwardAction() {
        super.setDetails("Seek Forward", 70);
        super.setTooltip("Seek forward to the next selection or view boundary");
        super.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.setEnabled(false);
    }

    protected int getIconSize() {
        return 20;
    }

    protected void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null && this.getCursorPosition() < currentFile.getView().getStopPosition() && this.getCursorPosition() < currentFile.getLength());
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioFile currentFile = this.session.getCurrentFile();
        SelectionInfo info = currentFile.getSelection();
        long curPos = this.getCursorPosition();
        long newPos = currentFile.getView().getStopPosition();
        long viewStart = currentFile.getView().getStartPosition();
        if (viewStart > curPos) {
            newPos = Math.min(newPos, viewStart);
        }
        for (ISelection selection : info.getSelections()) {
            long selStop;
            long selStart = selection.getBoundingStartPosition();
            if (selStart > curPos && selStart > viewStart) {
                newPos = Math.min(newPos, selStart);
            }
            if ((selStop = selection.getBoundingStopPosition()) <= curPos || selStop <= viewStart) continue;
            newPos = Math.min(newPos, selStop);
        }
        info.setCursorPosition(newPos);
        Transport.getInstance().seek(newPos);
        return false;
    }
}

