/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.transport.SeekActionBase;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class SkipToEndAction
extends SeekActionBase {
    public SkipToEndAction() {
        super.setDetails("Skip To End", 69);
        super.setTooltip("Seek forward to the end of the file");
        super.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.setEnabled(false);
    }

    protected int getIconSize() {
        return 20;
    }

    protected void refreshState() {
        AudioFile currentFile = this.session.getCurrentFile();
        this.setEnabled(currentFile != null && this.getCursorPosition() != currentFile.getLength());
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        AudioFile currentFile = this.session.getCurrentFile();
        SelectionInfo info = currentFile.getSelection();
        info.setCursorPosition(currentFile.getLength());
        Transport.getInstance().seek(currentFile.getLength());
        return false;
    }
}

