/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.transport;

import ch.tachyon.sonics.action.MenuBar;
import ch.tachyon.sonics.action.transport.TransportActionBase;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.core.TransportAdapter;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class StopAction
extends TransportActionBase {
    public StopAction() {
        super.setText("Stop");
        super.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        super.setMnemonic(83);
        super.addKeyboardShortcut(65480);
        this.setEnabled(false);
    }

    static StopAction getInstance() {
        return MenuBar.getInstance().getTransportMenu().getStopAction();
    }

    void requestFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StopAction.this.getToolbarButton().requestFocusInWindow();
            }
        });
    }

    protected void init() {
        Transport.getInstance().addTransportAdapter(new TransportAdapter(){

            public void playStateChanged(Transport transport, PlayState oldPlayState, PlayState newPlayState) {
                StopAction.this.refreshState();
                if (newPlayState == PlayState.PLAY) {
                    StopAction.this.requestFocus();
                }
            }
        });
    }

    protected int getIconSize() {
        return 20;
    }

    protected boolean guiPreProcess(ActionEvent e) throws Exception {
        Transport transport = Transport.getInstance();
        transport.setPlayState(PlayState.STOP);
        return false;
    }

    private void refreshState() {
        PlayState playState = Transport.getInstance().getPlayState();
        this.setEnabled(playState != PlayState.STOP);
    }
}

