/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewSelectionActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.selection.ISelection;
import ch.tachyon.sonics.data.selection.SelectionInfo;
import ch.tachyon.sonics.data.view.AudioDataView;

public class FitSelectionAction
extends ViewSelectionActionBase {
    public FitSelectionAction() {
        this((Session)null, (AudioFile)null);
    }

    public FitSelectionAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Fit Selection", 83);
        super.addKeyboardShortcut(83);
        super.setTooltip("Zoom so that the selection fits in the window");
        this.updateEnabledStatus();
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        return !file.getSelection().isEmpty();
    }

    protected void process(AudioFile file, AudioDataView view) {
        SelectionInfo selectionInfo = file.getSelection();
        if (selectionInfo.isEmpty()) {
            return;
        }
        long startPos = file.getLength();
        long stopPos = 0L;
        for (ISelection selection : selectionInfo.getSelections()) {
            if (selection.isEmpty()) continue;
            startPos = Math.min(startPos, selection.getBoundingStartPosition());
            stopPos = Math.max(stopPos, selection.getBoundingStopPosition());
        }
        startPos = Math.max(startPos, 0L);
        stopPos = Math.min(stopPos, file.getLength());
        view.setVisibleRange(startPos, stopPos);
    }
}

