/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;

public class FitVertAction
extends ViewActionBase {
    public FitVertAction() {
        this((Session)null, (AudioFile)null);
    }

    public FitVertAction(Session session, AudioFile audioFile) {
        super(session, audioFile);
        super.setDetails("Fit Vertically", 89);
        super.addKeyboardShortcut(86);
        super.setTooltip("Zoom vertically to show the entire [-1,+1] digital amplitude range");
        this.setEnabled(false);
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        float floor = view.getVerticalFloor();
        float ceil = view.getVerticalCeil();
        return floor != -1.0f || ceil != 1.0f;
    }

    protected void process(AudioFile file, AudioDataView view) {
        view.setVerticalRange(1.0f, -1.0f);
    }
}

