/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.Controller;
import ch.tachyon.sonics.action.MenuGroupBase;
import ch.tachyon.sonics.action.view.SetLookAndFeelAction;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.event.ActionEvent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import org.corebounce.common.utils.Platform;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel;
import org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel;
import org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel;

public class LookAndFeelAction
extends MenuGroupBase {
    public LookAndFeelAction(Controller controller) {
        super(controller);
        super.setDetails("Look & Feel", 75);
        super.setTooltip("Change the appearance (or \"skin\") of the user interface");
        this.installOptions();
    }

    private void installOptions() {
        LookAndFeel current = UIManager.getLookAndFeel();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = lookAndFeelInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo laf = lookAndFeelInfoArray[n2];
            String description = null;
            try {
                Class<?> lafClass = Class.forName(laf.getClassName());
                LookAndFeel instance = (LookAndFeel)lafClass.newInstance();
                description = instance.getDescription();
            }
            catch (Exception ex) {
                Debug.warn((Throwable)ex);
            }
            if (laf.getName().equals("Metal")) {
                SetLookAndFeelAction action = new SetLookAndFeelAction(laf.getClassName(), laf.getName(), description){

                    protected boolean guiPreProcess(ActionEvent e) {
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                        return super.guiPreProcess(e);
                    }
                };
                if (current.getClass().getName().equals(laf.getClassName()) && MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                    action.setSelected(true);
                }
                super.addItem(action);
                SetLookAndFeelAction action2 = new SetLookAndFeelAction(laf.getClassName(), "Steel", "The Java old and ugly \"Steel\" Look and Feel"){

                    protected boolean guiPreProcess(ActionEvent e) {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                        return super.guiPreProcess(e);
                    }
                };
                if (current.getClass().getName().equals(laf.getClassName()) && MetalLookAndFeel.getCurrentTheme() instanceof DefaultMetalTheme) {
                    action2.setSelected(true);
                }
                super.addItem(action2);
            } else {
                boolean system = UIManager.getSystemLookAndFeelClassName().equals(laf.getClassName());
                SetLookAndFeelAction action = new SetLookAndFeelAction(laf.getClassName(), String.valueOf(laf.getName()) + (system ? " (default)" : ""), description);
                if (current.getClass().getName().equals(laf.getClassName())) {
                    action.setSelected(true);
                }
                super.addItem(action);
            }
            ++n2;
        }
        SetLookAndFeelAction napkin = new SetLookAndFeelAction(NapkinLookAndFeel.class.getName(), "Napkin", "The Napkin Look and Feel");
        napkin.setSelected(current instanceof NapkinLookAndFeel);
        super.addItem(napkin);
        if (!Platform.isBelowJava16()) {
            System.setProperty("substancelaf.windowRoundedCorners", "false");
            SetLookAndFeelAction business = new SetLookAndFeelAction(SubstanceBusinessLookAndFeel.class.getName(), "Business", "Substance Business Look and Feel"){

                protected boolean guiPreProcess(ActionEvent e) {
                    super.guiPreProcess(e);
                    AnimationConfigurationManager.getInstance().setTimelineDuration(100L);
                    return true;
                }
            };
            business.setSelected(current instanceof SubstanceBusinessLookAndFeel);
            super.addItem(business);
            SetLookAndFeelAction twilight = new SetLookAndFeelAction(SubstanceTwilightLookAndFeel.class.getName(), "Twilight", "Substance Twilight Look and Feel"){

                protected boolean guiPreProcess(ActionEvent e) {
                    super.guiPreProcess(e);
                    AnimationConfigurationManager.getInstance().setTimelineDuration(0L);
                    return true;
                }
            };
            twilight.setSelected(current instanceof SubstanceTwilightLookAndFeel);
            super.addItem(twilight);
            SetLookAndFeelAction mistAqua = new SetLookAndFeelAction(SubstanceMistAquaLookAndFeel.class.getName(), "Mist Aqua", "Substance Mist Aqua Look and Feel"){

                protected boolean guiPreProcess(ActionEvent e) {
                    super.guiPreProcess(e);
                    AnimationConfigurationManager.getInstance().setTimelineDuration(200L);
                    return true;
                }
            };
            mistAqua.setSelected(current instanceof SubstanceMistAquaLookAndFeel);
            super.addItem(mistAqua);
        }
    }

    public boolean isRadioButtonGroup() {
        return true;
    }
}

