/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.ActionBase;
import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.core.PlayState;
import ch.tachyon.sonics.core.Transport;
import ch.tachyon.sonics.gui.TachyonSonicsFrame;
import ch.tachyon.tunnel.utils.Debug;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.JWindow;
import org.corebounce.common.gui.AwtTools;

public class SetLookAndFeelAction
extends ActionBase {
    private final String lafClassName;

    public SetLookAndFeelAction(String lafClassName, String lafName, String lafDescription) {
        this.lafClassName = lafClassName;
        super.setText(lafName);
        super.setTooltip(lafDescription);
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.RADIO;
    }

    protected boolean guiPreProcess(ActionEvent e) {
        Transport.getInstance().setPlayState(PlayState.STOP);
        return true;
    }

    protected void guiPostProcess(ActionEvent e) throws Exception {
        TachyonSonicsFrame frame = this.controller.getFrame();
        JWindow tmp = new JWindow();
        tmp.setSize(frame.getSize());
        tmp.setLocation(frame.getLocation());
        tmp.setCursor(Cursor.getPredefinedCursor(3));
        tmp.setVisible(true);
        try {
            AwtTools.swithToLookAndFeel(this.lafClassName);
        }
        catch (Exception ex) {
            Debug.error((Throwable)ex);
        }
        this.controller.rebuildFrame();
        tmp.setVisible(false);
        tmp.dispose();
    }
}

