/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.action.view;

import ch.tachyon.sonics.action.ActionDisplayType;
import ch.tachyon.sonics.action.view.ViewActionBase;
import ch.tachyon.sonics.data.Session;
import ch.tachyon.sonics.data.audio.AudioFile;
import ch.tachyon.sonics.data.view.AudioDataView;
import ch.tachyon.sonics.data.view.ChannelViewType;
import ch.tachyon.tunnel.utils.Utils;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import org.corebounce.common.gui.AwtTools;

public class SetViewTypeAction
extends ViewActionBase {
    private final ChannelViewType viewType;
    private final JComboBox parent;
    private ChannelViewType selectedViewType;

    public SetViewTypeAction(Session session, ChannelViewType viewType, AudioFile file, JComboBox parent, int accel, int mnemonic) {
        super(session, file);
        this.viewType = viewType;
        this.parent = parent;
        super.setText(viewType.toString());
        super.setAccelerator(KeyStroke.getKeyStroke(accel, 0));
        super.setMnemonic(mnemonic);
        if (file == null) {
            super.setEnabled(false);
        }
    }

    public ActionDisplayType getDisplayType() {
        return ActionDisplayType.RADIO;
    }

    protected boolean getEnabled(AudioFile file, AudioDataView view) {
        return file != null;
    }

    private void updateSelectedStatus(final AudioDataView view) {
        if (!Utils.eq((Object)((Object)this.selectedViewType), (Object)((Object)view.getViewType()))) {
            AwtTools.invokeInSwing(new Runnable(){

                public void run() {
                    boolean selected = false;
                    if (view != null) {
                        selected = SetViewTypeAction.this.viewType.equals((Object)view.getViewType());
                        SetViewTypeAction.this.setSelected(selected);
                    }
                    if (selected && SetViewTypeAction.this.parent != null) {
                        SetViewTypeAction.this.parent.setEnabled(false);
                        SetViewTypeAction.this.parent.setSelectedItem(SetViewTypeAction.this);
                        SetViewTypeAction.this.parent.setEnabled(true);
                    }
                }
            });
            this.selectedViewType = view.getViewType();
        }
    }

    public void viewChanged(AudioDataView view) {
        super.viewChanged(view);
        this.updateSelectedStatus(view);
    }

    protected void currentFileChanged(AudioFile previous, AudioFile current) {
        if (current != null && current.getView() != null) {
            this.updateSelectedStatus(current.getView());
        }
    }

    protected void process(AudioFile file, AudioDataView view) {
        if (file != null) {
            file.getView().setViewType(this.viewType);
        }
    }

    public String toString() {
        return this.viewType.toString();
    }
}

